% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ped_complex.R
\name{ped_complex}
\alias{ped_complex}
\alias{doubleCousins}
\alias{doubleFirstCousins}
\alias{quadHalfFirstCousins}
\alias{fullSibMating}
\alias{halfSibStack}
\title{Complex pedigree structures}
\usage{
doubleCousins(degree1, degree2, removal1 = 0, removal2 = 0,
  half1 = FALSE, half2 = FALSE, child = FALSE)

doubleFirstCousins()

quadHalfFirstCousins()

fullSibMating(n)

halfSibStack(n)
}
\arguments{
\item{degree1, degree2, removal1, removal2}{Nonnegative integers.}

\item{half1, half2}{Logicals, indicating if the fathers (resp. mothers) should
be full or half cousins.}

\item{child}{A logical: Should a child be added to the double cousins?}

\item{n}{A positive integer indicating the number of crossings.}
}
\value{
A \code{\link{ped}} object.
}
\description{
Functions for creating a selection of pedigrees that are awkward to construct
from scratch, or by using the simple structures described in \link{ped_basic}.
}
\details{
The function \code{doubleCousins} returns a pedigree linking two individuals who
are simultaneous paternal and maternal cousins. More precisely, they are:
\itemize{
\item paternal (full or half) cousins of type (\code{degree1}, \code{removal1})
\item maternal (full or half) cousins of type (\code{degree2}, \code{removal2}).
}

For convenience, a wrapper \code{doubleFirstCousins} is provided for the most
common case, double first cousins.

\code{quadHalfFirstCousins} produces a pedigree with quadruple half first cousins.

\code{fullSibMating} crosses full sibs consecutively \code{n} times.

\code{halfSibStack} produces a breeding scheme where the two individuals in the
final generation are simultaneous half k'th cousins, for each \code{k = 0,...,n-1}.
}
\examples{

# Consecutive brother-sister matings.
x = fullSibMating(2)
# plot(X)

# Simultaneous half siblings and half first cousins
x = halfSibStack(2)
# plot(x)

# Double first cousins
x = doubleFirstCousins()
# plot(x)

# Quadruple half first cousins
x = quadHalfFirstCousins()
# plot(x) # Weird plotting behaviour for this pedigree.

}
\seealso{
\link{ped_basic}
}
