% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/likelihood.R
\name{likelihood}
\alias{likelihood}
\alias{likelihood.ped}
\alias{likelihood.singleton}
\alias{likelihood.list}
\title{Pedigree likelihood}
\usage{
likelihood(x, ...)

\method{likelihood}{ped}(x, marker1, marker2 = NULL, theta = NULL,
  setup = NULL, eliminate = 0, logbase = NULL,
  loop_breakers = NULL, verbose = FALSE, ...)

\method{likelihood}{singleton}(x, marker1, marker2 = NULL,
  logbase = NULL, ...)

\method{likelihood}{list}(x, marker1, marker2 = NULL, logbase = NULL,
  total = TRUE, ...)
}
\arguments{
\item{x}{a \code{ped} object, a \code{singleton} object, or a list of such objects.}

\item{\dots}{further arguments.}

\item{marker1}{a \code{\link[=marker]{marker()}} object compatible with \code{x}. If \code{x} is a list,
then \code{marker1} must be a list of corresponding \code{marker} objects.}

\item{marker2}{either NULL, or a \code{\link[=marker]{marker()}} object compatible with \code{x}. See
Details.}

\item{theta}{the recombination rate between \code{marker1} and \code{marker2}. To make
biological sense \code{theta} should be between 0 and 0.5.}

\item{setup}{for internal use.}

\item{eliminate}{mostly for internal use: a non-negative integer indicating
the number of iterations in the internal genotype-compatibility algorithm.
Positive values can save time if the number of alleles is large.}

\item{logbase}{a numeric, or NULL. If numeric the log-likelihood is returned,
with \code{logbase} as basis for the logarithm.}

\item{loop_breakers}{a vector of ID labels indicating loop breakers. If NULL
(default), automatic selection of loop breakers will be performed. See
\code{\link[=breakLoops]{breakLoops()}}.}

\item{verbose}{a logical}

\item{total}{a logical; if TRUE, the product of the likelihoods is returned,
otherwise a vector with the likelihoods for each pedigree in the list.}
}
\value{
The likelihood of the data. If the parameter \code{logbase} is a
positive number, the output is \code{log(likelihood, logbase)}.
}
\description{
This function is the heart of pedprobr. It computes the likelihood of a
pedigree (or a list of pedigrees) given genotypes for a marker or a pair of
linked markers.
}
\details{
The implementation is based on the peeling algorithm of Elston and Stewart (1971). A
variety of situations are covered; see the Examples section for some demonstrations.
\itemize{
\item complex inbred pedigrees
\item pedigrees with inbred founders
\item autosomal and X-linked markers
\item a single marker or two linked markers
\item markers with mutation models
}
}
\examples{

### Example 1: Likelihood of trio with inbred father

x = cousinPed(0, child = TRUE)
x = addSon(x, 5)
x = relabel(x, old = 5:7, new = c("father", "mother", "child"))

# Equifrequent SNP marker: father homozygous, child heterozygous
m = marker(x, father = 1, child = 1:2)
x = addMarkers(x, m)

# Plot with genotypes
plot(x, marker = 1)

# Compute the likelihood
lik1 = likelihood(x, marker1 = 1)


### Example 2: Same as above, but using founder inbreeding

# Extract the trio
y = subset(x, c("father", "mother", "child"))

# Indicate that the father has inbreeding coefficient 1/4
founderInbreeding(y, "father") = 1/4

# Plot (notice the inbreeding coefficient)
plot(y, marker = 1)

# Likelihood should be the same as above
lik2 = likelihood(y, marker1 = 1)

stopifnot(all.equal(lik1, lik2))


### Example 3: Modelling mutations
# TODO after next pedtools release

}
\references{
Elston and Stewart (1971), \doi{10.1159/000152448}
}
\author{
Magnus Dehli Vigeland
}
