% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lumpedModel.R
\name{lumpedMatrix}
\alias{lumpedMatrix}
\alias{lumpedModel}
\title{Combine alleles in a mutation matrix}
\usage{
lumpedMatrix(mutmat, lump, afreq = NULL, check = TRUE, labelSep = NULL)

lumpedModel(mutmod, lump, afreq = NULL, check = TRUE)
}
\arguments{
\item{mutmat}{A \code{mutationMatrix} object, typically made with
\code{\link[=mutationMatrix]{mutationMatrix()}}.}

\item{lump}{A nonempty subset of the alleles (i.e., the column names of
\code{mutmat}), or a list of several such subsets.}

\item{afreq}{A vector with frequency vector, of the same length as the size
of \code{mutmat}. If not given, the \code{afreq} attribute of the matrix is used.}

\item{check}{A logical indicating if lumpability should be checked before
lumping. Default: TRUE.}

\item{labelSep}{((For debugging) A character used to name lumps by pasting
allele labels.}

\item{mutmod}{A \code{mutationModel} object, typically made with
\code{\link[=mutationModel]{mutationModel()}}.}
}
\value{
A reduced mutation model. If the original matrix has dimensions
\eqn{n\times n}{n*n}, the result will be \eqn{k\times k}{k*k}, where \eqn{k
  = n - length(lump) + 1}.
}
\description{
Reduce a mutation matrix by combining a set of alleles into one "lump", if
this can be done without distorting the mutation process of the remaining
alleles. Such "allele lumping" can give dramatic efficiency improvements in
likelihood computations with multi-allelic markers, in cases where only some
of the alleles are observed in the pedigree.
}
\examples{


### Example 1: Lumping a mutation matrix
mat = mutationMatrix("eq", alleles = 1:5,
                     afreq = rep(0.2, 5), rate = 0.1)
mat

# Lump alleles 3, 4 and 5
mat2 = lumpedMatrix(mat, lump = 3:5)
mat2

# Example 2: Full model, proportional
mutrate = list(male = 0.1, female = 0.2)
mod = mutationModel("prop", alleles = 1:4,
                    rate = mutrate, afreq = c(.1,.2,.3,.4))
mod

# Lump alleles 3 and 4
mod2 = lumpedModel(mod, lump = 3:4)
mod2

}
\seealso{
\code{\link[=mutationModel]{mutationModel()}}, \code{\link[=mutationMatrix]{mutationMatrix()}}
}
