% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oneSample.R
\name{oneSample}
\alias{oneSample}
\title{Permutatation-based one sample t-test}
\usage{
oneSample(X, B = 1000, seed = 1234, permReturn = TRUE)
}
\arguments{
\item{X}{data matrix where columns represent the \code{m} variables and rows the \code{n} observations.}

\item{B}{numeric value, number of permutations to be performed, including the identity. Default is 1000.}

\item{seed}{numeric value, specify seed. Default is 1234.}

\item{permReturn}{logical value, \code{TRUE} to return the t-tests permutation distribution. Default is \code{TRUE}.}
}
\value{
Returns an object matrix:
\describe{ 
  \item{tv}{Matrix with dimensions \eqn{m x B} of permuted one-sample t-tests. The first column is the observed one-sample t-tests.}}
  if \code{permReturn = TRUE} otherwise returns:
\describe{ 
  \item{tv}{Vector of \eqn{m} observed one-sample t-tests}}
}
\description{
Performs sign-flipped one-sample t-tests.
}
\examples{
X <- matrix(rnorm(100*20), nrow=20)
out <- oneSample(X = X)
}
\author{
Angela Andreella
}
