% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pdynmc_specTestFcst.R
\name{jtest.fct}
\alias{jtest.fct}
\title{Hansen J-Test.}
\usage{
jtest.fct(object)
}
\arguments{
\item{object}{An object of class `pdynmc`.}
}
\value{
An object of class `htest` which contains the Hansen J-test statistic
   and corresponding p-value for the null hypothesis that the overidentifying
   restrictions are valid.
}
\description{
\code{jtest.fct} tests the validity of the overidentifying restrictions.
}
\details{
The null hypothesis is that the overidentifying restrictions are valid.
   The test statistic is computed as proposed by
   \insertCite{Han1982large;textual}{pdynmc}. As noted by
   \insertCite{Bow2002testing;textual}{pdynmc} and
   \insertCite{Win2005;textual}{pdynmc}
   the test statistic is weakened by many instruments.
}
\examples{
## Load data
data(ABdata, package = "pdynmc")
dat <- ABdata
dat[,c(4:7)] <- log(dat[,c(4:7)])
dat <- dat[c(140:0), ]

## Code example
m1 <- pdynmc(dat = dat, varname.i = "firm", varname.t = "year",
    use.mc.diff = TRUE, use.mc.lev = FALSE, use.mc.nonlin = FALSE,
    include.y = TRUE, varname.y = "emp", lagTerms.y = 2,
    fur.con = TRUE, fur.con.diff = TRUE, fur.con.lev = FALSE,
    varname.reg.fur = c("wage", "capital", "output"), lagTerms.reg.fur = c(1,2,2),
    include.dum = TRUE, dum.diff = TRUE, dum.lev = FALSE, varname.dum = "year",
    w.mat = "iid.err", std.err = "corrected", estimation = "onestep",
    opt.meth = "none")
jtest.fct(m1)

\donttest{
## Load data
 data(ABdata, package = "pdynmc")
 dat <- ABdata
 dat[,c(4:7)] <- log(dat[,c(4:7)])

## Further code example
 m1 <- pdynmc(dat = dat, varname.i = "firm", varname.t = "year",
    use.mc.diff = TRUE, use.mc.lev = FALSE, use.mc.nonlin = FALSE,
    include.y = TRUE, varname.y = "emp", lagTerms.y = 2,
    fur.con = TRUE, fur.con.diff = TRUE, fur.con.lev = FALSE,
    varname.reg.fur = c("wage", "capital", "output"), lagTerms.reg.fur = c(1,2,2),
    include.dum = TRUE, dum.diff = TRUE, dum.lev = FALSE, varname.dum = "year",
    w.mat = "iid.err", std.err = "corrected", estimation = "onestep",
    opt.meth = "none")
 jtest.fct(m1)
}


}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{pdynmc}} for fitting a linear dynamic panel data model.
}
