% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoplot.R
\name{autoplot.partial}
\alias{autoplot.partial}
\alias{autoplot.ice}
\alias{autoplot.cice}
\title{Plotting Partial Dependence Functions}
\usage{
\method{autoplot}{partial}(object, center = FALSE, plot.pdp = TRUE,
  pdp.color = "red", pdp.size = 1, pdp.linetype = 1, rug = FALSE,
  smooth = FALSE, smooth.method = "auto", smooth.formula = y ~ x,
  smooth.span = 0.75, smooth.method.args = list(), contour = FALSE,
  contour.color = "white", palette = "Spectral", train = NULL,
  xlab = NULL, ylab = NULL, main = NULL, legend.title = NULL, ...)

\method{autoplot}{ice}(object, center = FALSE, plot.pdp = TRUE,
  pdp.color = "red", pdp.size = 1, pdp.linetype = 1, rug = FALSE,
  train = NULL, xlab = NULL, ylab = NULL, main = NULL, ...)

\method{autoplot}{cice}(object, plot.pdp = TRUE, pdp.color = "red",
  pdp.size = 1, pdp.linetype = 1, rug = FALSE, train = NULL,
  xlab = NULL, ylab = NULL, main = NULL, ...)
}
\arguments{
\item{object}{An object that inherits from the \code{"partial"} class.}

\item{center}{Logical indicating whether or not to produce centered ICE
curves (c-ICE curves). Only useful when \code{object} represents a set of ICE
curves; see \code{\link[pdp]{partial}} for details. Default is \code{FALSE}.}

\item{plot.pdp}{Logical indicating whether or not to plot the partial
dependence function on top of the ICE curves. Default is \code{TRUE}.}

\item{pdp.color}{Character string specifying the color to use for the partial
dependence function when \code{plot.pdp = TRUE}. Default is \code{"red"}.}

\item{pdp.size}{Positive number specifying the line width to use for the
partial dependence function when \code{plot.pdp = TRUE}. Default is \code{1}.}

\item{pdp.linetype}{Positive number specifying the line type to use for the
partial dependence function when \code{plot.pdp = TRUE}. Default is \code{1}.}

\item{rug}{Logical indicating whether or not to include rug marks on the
predictor axes. Default is \code{FALSE}.}

\item{smooth}{Logical indicating whether or not to overlay a LOESS smooth.
Default is \code{FALSE}.}

\item{smooth.method}{Character string specifying the smoothing method
(function) to use (e.g., \code{"auto"}, \code{"lm"}, \code{"glm"},
\code{"gam"}, \code{"loess"}, or \code{"rlm"}). Default is \code{"auto"}.
See \code{\link[ggplot2]{geom_smooth}} for details.}

\item{smooth.formula}{Formula to use in smoothing function (e.g.,
\code{y ~ x}, \code{y ~ poly(x, 2)}, or \code{y ~ log(x)}).}

\item{smooth.span}{Controls the amount of smoothing for the default loess
smoother. Smaller numbers produce wigglier lines, larger numbers produce
smoother lines. Default is \code{0.75}.}

\item{smooth.method.args}{List containing additional arguments to be passed
on to the modelling function defined by \code{smooth.method}.}

\item{contour}{Logical indicating whether or not to add contour lines to the
level plot. Only used when \code{levelplot = TRUE}. Default is \code{FALSE}.}

\item{contour.color}{Character string specifying the color to use for the
contour lines when \code{contour = TRUE}. Default is \code{"white"}.}

\item{palette}{If a string, will use that named palette. If a number, will
index into the list of palettes of appropriate type. Default is
\code{"Spectral"}.}

\item{train}{Data frame containing the original training data. Only required
if \code{rug = TRUE} or \code{chull = TRUE}.}

\item{xlab}{Charater string specifying the text for the x-axis label.}

\item{ylab}{Charater string specifying the text for the y-axis label.}

\item{main}{Character string specifying the text for the main title of the
plot.}

\item{legend.title}{Charater string specifying the text for the legend title.
Default is \code{"yhat"}.}

\item{...}{Additional optional arguments to be passed onto \code{geom_line}.}
}
\value{
A \code{"ggplot"} object.
}
\description{
Plots partial dependence functions (i.e., marginal effects) using
\code{\link[ggplot2]{ggplot2}} graphics.
}
\examples{
\dontrun{
#
# Regression example (requires randomForest package to run)
#

# Load required packages
library(ggplot2)  # required to use autoplot
library(randomForest)

# Fit a random forest to the Boston housing data
data (boston)  # load the boston housing data
set.seed(101)  # for reproducibility
boston.rf <- randomForest(cmedv ~ ., data = boston)

# Partial dependence of cmedv on lstat
boston.rf \%>\%
  partial(pred.var = "lstat") \%>\%
  autoplot(rug = TRUE, train = boston)

# Partial dependence of cmedv on lstat and rm
boston.rf \%>\%
  partial(pred.var = c("lstat", "rm"), chull = TRUE, progress = "text") \%>\%
  autoplot(contour = TRUE, legend.title = "rm")

# ICE curves and c-ICE curves
age.ice <- partial(boston.rf, pred.var = "lstat", ice = TRUE)
grid.arrange(
  autoplot(age.ice, alpha = 0.5),                 # ICE curves
  autoplot(age.ice, center = TRUE, alpha = 0.5),  # c-ICE curves
  ncol = 2
)
}
}
