% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pdfbox.R
\name{read_text}
\alias{read_text}
\title{Read Text from PDF}
\usage{
read_text(
  file,
  pages = integer(),
  password = "",
  max_memory = -1L,
  temp_dir = tempdir()
)
}
\arguments{
\item{file}{path to PDF file (is auto-expanded with [path.expand()])}

\item{pages}{an \code{integer} vector giving the pages which should be extracted 
(default is \code{integer()}).}

\item{password}{a string providing the password of the file.}

\item{max_memory}{an integer giving the maximum number of main-memory in MB 
to be used by \pkg{pdfbox}. The default is \code{-1L} which means 
there is no limit. If a limit is set \pkg{pdfbox} will try to stay
below by performing out of memory computations.
Since the memory of the \code{Java} virtual machine
is already limited it is recommended to choose the value of \code{max\_memory}
below the memory limit of the virtual machine (\code{options("java.parameters")}).
If the memory of the \code{Java} virtual machine is big enough 
this options is never needed.}

\item{temp_dir}{a character string giving the path to a temporary directory.}
}
\value{
Returns a object of class \code{"data.frame"}.
}
\description{
Read text from a PDF file.
}
\examples{
pdf_file <- system.file("pdfs/cars.pdf", package = "pdfboxr")
pdf <- read_text(pdf_file)
pdf
}
