% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inference.R
\name{pdConfInt1D}
\alias{pdConfInt1D}
\title{Intrinsic depth-based bootstrap confidence regions}
\usage{
pdConfInt1D(f, alpha = 0.05, ci.region, boot.samples = 1000,
  metric = "logEuclidean", depth = "spatial", return.f = F, f.0 = NULL,
  ...)
}
\arguments{
\item{f}{a (\eqn{d,d,m})-dimensional array corresponding to a wavelet-denoised HPD (\eqn{d,d})-dimensional
spectral estimate at \code{m} different frequencies given as output with \code{\link{pdSpecEst1D}}.}

\item{alpha}{a numerical vector of quantiles (between 0 and 1) determining the \eqn{100(1-\alpha)\%}-confidence levels,
defaults to \code{alpha = 0.05}.}

\item{ci.region}{a 2-dimensional numeric vector \code{c(min.ci, max.ci)} specifying the domain of the simultaneous confidence region.
The frequency domain \eqn{[0, \pi]} is normalized to a unit interval, e.g. \code{ci.region = c(0.5, 1)} constructs a simultaneous
confidence region over the second half of the frequency domain. \code{ci.region} can also be a \eqn{(2,L)}-dimensional matrix, where each
column of the matrix specificies the domain of an individual simultaneous confidence region. If \code{ci.region} is not specified, it defaults
to the unit interval, i.e. the entire frequency domain.}

\item{boot.samples}{number of bootstrap spectral estimates, defaults to \code{boot.samples = 1e3}.}

\item{metric}{the metric that the space of HPD matrices is equipped with. The default choice is \code{"logEuclidean"},
but this can also be one of: \code{"Riemannian"}, \code{"Cholesky"}, \code{"rootEuclidean"} or
\code{"Euclidean"}. This argument is passed on to the spectral estimator in \code{\link{pdSpecEst1D}} and the depth calculation in
\code{\link{pdDepth}}. The default choice is the Log-Euclidean metric as the computational effort is significantly reduced
in comparison to e.g. the Riemannian metric.}

\item{depth}{the data depth measure, one of \code{'zonoid'}, \code{'gdd'}, or \code{'spatial'} corresponding to
the manifold zonoid depth, geodesic distance depth, and manifold spatial depth respectively.}

\item{return.f}{a logical value, if \code{return.f = TRUE} the function also returns the \eqn{100(1-\alpha)\%}-most central bootstrapped
spectral estimates. By default \code{return.f = FALSE} to save memory use of the returned object.}

\item{f.0}{optional target spectrum in the same format as \code{f}. The function computes the depth of the target spectrum with respect to
the cloud of bootstrap spectral estimates and checks whether the target \code{f.0} is covered by the constructed depth-based confidence region.}

\item{...}{additional arguments passed on to the functions \code{\link{pdPgram}} and \code{\link{pdSpecEst1D}} used internally.}
}
\value{
The function returns a list with the following components:
\item{depth.CI }{ a matrix or a list of matrices, with each matrix giving the depth-based confidence ball (maximum depth, minimum depth and radius)
at an individual region in the frequency domain as specified by the argument \code{ci.region} and at the various \eqn{100(1-\alpha)\%}-confidence
 levels specified by the argument \code{alpha}. }
\item{f.CI }{ If \code{return.f = TRUE} returns the \eqn{100(1-\alpha)\%}-most central bootstrapped spectral estimates at each of the individual regions
in the frequency domain specified by the argument \code{ci.region} at the level corresponding to the first argument in the input vector \eqn{\alpha}.
If \code{return.f = FALSE} returns \code{NULL}.}
If a target spectrum \code{f.0} is supplied, i.e. \code{!is.null(f.0)}, the returned list includes the additional components:
\item{cover.f }{ a list of logical vectors checking whether the constructed confidence balls cover the target spectrum \code{f.0}. Each vector corresponds
to an individual region in the frequency domain as specified by the argument \code{ci.region} at the various \eqn{100(1-\alpha)\%}-confidence levels
specified by the argument \code{alpha}.}
\item{depth.f }{ a numeric vector of depth values of the target spectrum \code{f.0} with respect to the cloud of bootstrapped spectral estimates at each of
the individual regions in the frequency domain as specified by the argument \code{ci.region}.}
}
\description{
\code{pdConfInt1D} constructs depth-based parametric bootstrap confidence regions as explained in
(Chau and von Sachs, 2017a) for a wavelet-based spectral matrix estimator obtained with \code{\link{pdSpecEst1D}}
based on intrinsic manifold data depths  as in \code{\link{pdDepth}}.
}
\details{
The parametric bootstrap procedure exploits the data generating process of a stationary time series
via its Cramer representation, and is equivalent to e.g. (Fiecas and Ombao, 2016) among others.
Given a consistent wavelet-based spectral estimator \code{f} obtained with \code{\link{pdSpecEst1D}} corresponding
to a sequence of \eqn{m} HPD matrices along the frequency range \eqn{(0, \pi]}, where w.l.o.g. \eqn{m} is assumed
to be even, the bootstrap confidence regions are constructed as:
\enumerate{
   \item Generate a bootstrapped time series trace \code{X_b} of length \eqn{n} via its Cramer representation using
   complex normal random variates and transfer functions given by the Hermitian square root of the estimate \code{f}.
   \item Compute a bootstrapped wavelet-based spectral estimate \code{f_b} based on \code{X_b}.
   \item Repeat 1. and 2. many times. Construct \eqn{100(1-\alpha)\%}-pointwise or -simultaneous confidence sets
   by taking the \eqn{100(1-\alpha)\%}-most central depth-based region in the cloud of bootstrapped spectral estimates
   based on one of the intrinsic manifold data depths in \code{\link{pdDepth}}.
}
The depth-based confidence balls (maximum/minimum depths and radii) are given by the component \code{depth.CI}. In particular,
a given curve of HPD matrices is covered by the confidence ball if its manifold data depth with respect to the cloud of
bootstrapped spectral estimates is above the minimum depth in the given confidence ball. \cr
If \code{return.f = TRUE}, the function also returns the \eqn{100(1-\alpha)\%}-most central bootstrapped spectral estimates,
by default \code{return.f = FALSE} to save memory use of the returned object. \cr
If, in addition, we supply a target spectrum \code{f.0} (i.e. a numerical
array with the same dimensions as \code{f}), the function checks whether the target \code{f.0} is covered by the
constructed confidence regions or not by computing the depth of \code{f.0} with respect to the cloud of bootstrapped spectral
estimates.
}
\examples{
\dontrun{
set.seed(123)
example <- rExamples(2^8, example = "gaussian")
f.hat <- pdSpecEst1D(example$per, metric = "logEuclidean")
boot.ci <- pdConfInt1D(f.hat$f, alpha = c(0.1, 0.05, 0.01), ci.region = c(0.45, 0.55),
                       boot.samples = 1E3, f.0 = example$f)
boot.ci
}

}
\references{
Chau, J. and von Sachs, R. (2017a). \emph{Positive definite multivariate spectral
estimation: a geometric wavelet approach}. Available at \url{http://arxiv.org/abs/1701.03314}.

Chau, J., Ombao, H., and von Sachs, R. (2017b). \emph{Data depth and rank-based
tests for covariance and spectral density matrices}. Available at \url{http://arxiv.org/abs/1706.08289}.

Fiecas, M., Ombao, H. (2016). \emph{Modeling the evolution of dynamic brain processes during
an associative learning experiment}. Journal of the American Statistical Association, 111(516), 1440-1453.
}
