% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wue.R
\name{pwue}
\alias{pwue}
\title{Calculate pseudo water use efficiency from phenotype and watering data}
\usage{
pwue(
  df,
  w,
  pheno = "area_pixels",
  time = "timestamp",
  id = "barcode",
  offset = 0,
  waterCol = "water_amount",
  method = "rate"
)
}
\arguments{
\item{df}{Dataframe containing wide single-value phenotype data.
This should already be aggregated to one row per plant per day (angles/rotations combined).}

\item{w}{Watering data as returned from bw.water.}

\item{pheno}{Phenotype column name, defaults to "area_pixels"}

\item{time}{Variable(s) that identify a plant on a given day.
Defaults to \code{c("barcode", "DAS")}.}

\item{id}{Variable(s) that identify a plant over time. Defaults to \code{"barcode"}.}

\item{offset}{Optionally you can specify how long before imaging a watering should not be taken into
account. This defaults to 0, meaning that if a plant were watered directly before being imaged then
that water would be counted towards WUE between the current image and the prior one.
This argument is taken to be in seconds.}

\item{waterCol}{Column containing watering amounts in \code{w}. This defaults to "watering_amount".}

\item{method}{Which method to use, options are "rate" and "abs". The "rate" method considers WUE as
the change in a phenotype divided by the amount of water added. The "abs" method considers WUE as
the amount of water used by a plant given its absolute size. The former is for questions more
related to efficiency in using water to grow while the latter is more suited to questions about
how efficient a plant is at maintaining size given some amount of water.}
}
\value{
A data frame containing the bellwether watering data joined
    to phenotype data with new columns for change in the phenotype,
    change in the pre-watering weight, and pseudo-water use efficiency (pWUE).
}
\description{
Rate based water use efficiency (WUE) is the change in biomass per unit of water
metabolized. Using image based phenotypes and watering data we can calculate pseudo-WUE (pwue) over
time. Here area_pixels is used as a proxy for biomass and transpiration is approximated using
watering data. The equation is then
\eqn{
\frac{P_{t} - P_{t-1}}{W_{t_{end-1}}-W_{t_{start}} }}{P_[t] - P_[t-1] / W_[t_(end-1)]-W_[t_start]
},
where P is the phenotype and W is the weight before watering.

Absolute value based WUE is the amount of water used to sustain a plants biomass over a given period.
The equation is then
\eqn{\frac{P_{t}}{W_{t_{end-1}}-W_{t_{start}} }}{P_[t] / W_[t_(end-1)]-W_[t_start]}
}
\examples{
sim_water <- data.frame("barcode" = "exampleBarcode1",
"timestamp" = as.POSIXct(c("2023-04-13 23:28:17 UTC",
                           "2023-04-22 05:30:42 UTC",
                           "2023-05-04 18:55:38 UTC")),
"DAS" = c(0.000000,  8.251675, 20.810660),
"water_amount" = c(98, 12, -1)
)
sim_df <- data.frame("barcode" = "exampleBarcode1",
                     "timestamp" = as.POSIXct(c("2023-04-13 23:28:17 UTC",
                                                "2023-04-22 05:30:42 UTC",
                                                "2023-05-04 18:55:38 UTC")),
                     "DAS" = c(0.000000,  8, 20),
                     "area_pixels" = c(20, 1000, 1500)
)
pwue(
  df = sim_df, w = sim_water, pheno = "area_pixels",
  time = "timestamp", id = "barcode", offset = 0,
  waterCol = "water_amount", method = "rate"
)

pwue(
  df = sim_df, w = sim_water, pheno = "area_pixels",
  time = c("timestamp", "timestamp"), id = "barcode", offset = 0,
  waterCol = "water_amount", method = "abs"
)

}
\keyword{WUE}
