% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PatternGen.R
\name{runif.multi.tri}
\alias{runif.multi.tri}
\title{Generation of Uniform Points in the Convex Hull of Points}
\usage{
runif.multi.tri(n, Yp, DTmesh = NULL)
}
\arguments{
\item{n}{A positive integer
representing the number of uniform points to be generated
in the convex hull of the point set \code{Yp}.}

\item{Yp}{A set of 2D points
whose convex hull is the support of the uniform points to be generated.}

\item{DTmesh}{Triangulation nodes with neighbours
(result of \code{\link[interp]{tri.mesh}} function from
\code{interp} package).}
}
\value{
A \code{list} with the elements
\item{type}{The type of the pattern
from which points are to be generated}
\item{mtitle}{The \code{"main"} title
for the plot of the point pattern}
\item{tess.points}{The points
which constitute the vertices of the triangulation and
whose convex hull determines the support of the generated points.}
\item{gen.points}{The output set of generated points uniformly
in the convex hull of \code{Yp}}
\item{out.region}{The outer region which contains the support region,
\code{NULL} for this function.}
\item{desc.pat}{Description of the point pattern
from which points are to be generated}
\item{num.points}{The \code{vector} of two numbers,
which are the number of generated points and
the number of vertices in the triangulation
(i.e., size of \code{Yp}) points.}
\item{txt4pnts}{Description of the two numbers in \code{num.points}}
\item{xlimit,ylimit}{The ranges of the \eqn{x}-
and \eqn{y}-coordinates of the points in Yp}
}
\description{
An object of class \code{"Uniform"}.
Generates \code{n} points uniformly
in the Convex Hull of set of points, \code{Yp}.
That is, generates uniformly in each of the triangles
in the Delaunay triangulation of \code{Yp}, i.e.,
in the multiple triangles partitioning the convex hull of \code{Yp}.

If \code{Yp} consists only of 3 points,
then the function behaves like the
function \code{\link{runif.tri}}.

\code{DTmesh} is the Delaunay triangulation of \code{Yp},
default is \code{DTmesh=NULL}.
\code{DTmesh} yields triangulation nodes with neighbours
(result of \code{\link[interp]{tri.mesh}} function
from \code{interp} package).

See (\insertCite{okabe:2000,ceyhan:comp-geo-2010,sinclair:2016;textual}{pcds})
for more on Delaunay triangulation and the corresponding algorithm.
}
\examples{
\dontrun{
#nx is number of X points (target) and ny is number of Y points (nontarget)
nx<-100; ny<-4;  #try also nx<-1000; ny<-10;
set.seed(1)
Yp<-cbind(runif(ny,0,10),runif(ny,0,10))

Xdt<-runif.multi.tri(nx,Yp)
#data under CSR in the convex hull of Ypoints
Xdt
summary(Xdt)
plot(Xdt)

Xp<-Xdt$g
#or use
DTY<-interp::tri.mesh(Yp[,1],Yp[,2],duplicate="remove")
#Delaunay triangulation based on Y points
Xp<-runif.multi.tri(nx,Yp,DTY)$g
#data under CSR in the convex hull of Ypoints

Xlim<-range(Yp[,1])
Ylim<-range(Yp[,2])
xd<-Xlim[2]-Xlim[1]
yd<-Ylim[2]-Ylim[1]

#plot of the data in the convex hull of Y points together with the Delaunay triangulation
plot(Xp, xlab=" ", ylab=" ",
main="Uniform Points in Convex Hull of Y Points",
xlim=Xlim+xd*c(-.05,.05),ylim=Ylim+yd*c(-.05,.05),type="n")
interp::plot.triSht(DTY, add=TRUE,
do.points = TRUE,pch=16,col="blue")
points(Xp,pch=".",cex=3)

Yp<-rbind(c(.3,.2),c(.4,.5),c(.14,.15))
runif.multi.tri(nx,Yp)
}

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{runif.tri}}, \code{\link{runif.std.tri}},
and \code{\link{runif.basic.tri}},
}
\author{
Elvan Ceyhan
}
