% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PropEdge2D.R
\name{num.arcsPEstd.tri}
\alias{num.arcsPEstd.tri}
\title{Number of arcs of Proportional Edge Proximity Catch Digraphs (PE-PCDs)
and quantities related to the triangle - standard equilateral triangle case}
\usage{
num.arcsPEstd.tri(Xp, r, M = c(1, 1, 1))
}
\arguments{
\item{Xp}{A set of 2D points
which constitute the vertices of the PE-PCD.}

\item{r}{A positive real number
which serves as the expansion parameter for PE proximity region;
must be \eqn{\ge 1}.}

\item{M}{A 2D point in Cartesian coordinates
or a 3D point in barycentric coordinates
which serves as a center
in the interior of the standard equilateral triangle \eqn{T_e};
default is \eqn{M=(1,1,1)} i.e.
the center of mass of \eqn{T_e}.}
}
\value{
A \code{list} with the elements
\item{desc}{A short description of the output: number of arcs
and quantities related to the standard equilateral triangle}
\item{num.arcs}{Number of arcs of the PE-PCD}
\item{num.in.tri}{Number of \code{Xp} points
in the standard equilateral triangle, \eqn{T_e}}
\item{ind.in.tri}{The vector of indices of the \code{Xp} points
that reside in \eqn{T_e}}
\item{tess.points}{Points on which the tessellation of the study region is performed, here, tessellation
is the support triangle \eqn{T_e}.}
\item{vertices}{Vertices of the digraph, \code{Xp}.}
}
\description{
An object of class \code{"NumArcs"}.
Returns the number of arcs of
Proportional Edge Proximity Catch Digraphs (PE-PCDs)
whose vertices are the
given 2D numerical data set, \code{Xp}
in the standard equilateral triangle.
It also provides number of vertices
(i.e., number of data points inside the standard equilateral triangle \eqn{T_e})
and indices of the data points that reside in \eqn{T_e}.

PE proximity region \eqn{N_{PE}(x,r)} is defined
with respect to the standard equilateral triangle
\eqn{T_e=T(v=1,v=2,v=3)=T((0,0),(1,0),(1/2,\sqrt{3}/2))}
with expansion parameter \eqn{r \ge 1}
and vertex regions are based on the center \eqn{M=(m_1,m_2)}
in Cartesian coordinates or \eqn{M=(\alpha,\beta,\gamma)}
in barycentric coordinates in the interior of \eqn{T_e};
default is \eqn{M=(1,1,1)}, i.e., the center of mass of \eqn{T_e}.
For the number of arcs, loops are not allowed so
arcs are only possible for points inside \eqn{T_e} for this function.

See also (\insertCite{ceyhan:arc-density-PE;textual}{pcds}).
}
\examples{
\dontrun{
A<-c(0,0); B<-c(1,0); C<-c(1/2,sqrt(3)/2);
n<-10  #try also n<-20

set.seed(1)
Xp<-runif.std.tri(n)$gen.points

M<-c(.6,.2)  #try also M<-c(1,1,1)

Narcs = num.arcsPEstd.tri(Xp,r=1.25,M)
Narcs
summary(Narcs)
par(pty="s")
plot(Narcs,asp=1)
}

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{num.arcsPEtri}}, \code{\link{num.arcsPE}},
and \code{\link{num.arcsCSstd.tri}}
}
\author{
Elvan Ceyhan
}
