% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PropEdge1D.R
\name{PEdom.num.binom.test1Dint}
\alias{PEdom.num.binom.test1Dint}
\title{A test of uniformity for 1D data based on domination number of Proportional Edge Proximity Catch Digraph
(PE-PCD) - Binomial Approximation}
\usage{
PEdom.num.binom.test1Dint(
  Xp,
  support.int,
  c = 0.5,
  asy.bin = FALSE,
  alternative = c("two.sided", "less", "greater"),
  conf.level = 0.95
)
}
\arguments{
\item{Xp}{A set of 1D points which constitute the vertices of the PE-PCD.}

\item{support.int}{Support interval \eqn{(a,b)} with \eqn{a<b}.
Uniformity of \code{Xp} points in this interval is tested.}

\item{c}{A positive real number which serves as the centrality parameter in PE proximity region;
must be in \eqn{(0,1)} (default \code{c=.5}).}

\item{asy.bin}{A logical argument for the use of asymptotic probability of success for the binomial distribution,
default \code{asy.bin=FALSE}. When \code{asy.bin=TRUE}, asymptotic probability of success for the binomial distribution is used.
When \code{asy.bin=FALSE}, the finite sample asymptotic probability of success for the binomial distribution is used with number
of trials equals to expected number of \code{Xp} points per partition interval.}

\item{alternative}{Type of the alternative hypothesis in the test, one of \code{"two.sided"}, \code{"less"}, \code{"greater"}.}

\item{conf.level}{Level of the confidence interval, default is \code{0.95}, for the probability of success
(i.e., \eqn{Pr(}domination number\eqn{\le 1)} for PE-PCD whose vertices are the 1D data set \code{Xp}.}
}
\value{
A \code{list} with the elements
\item{statistic}{Test statistic}
\item{p.value}{The \eqn{p}-value for the hypothesis test for the corresponding \code{alternative}}
\item{conf.int}{Confidence interval for \eqn{Pr(}domination number\eqn{\le 1)} at the given level \code{conf.level} and
depends on the type of \code{alternative}.}
\item{estimate}{A \code{vector} with two entries: first is is the estimate of the parameter, i.e.,
\eqn{Pr(}domination number\eqn{\le 1)} and second is the domination number}
\item{null.value}{Hypothesized value for the parameter, i.e., the null value for \eqn{Pr(}domination number\eqn{\le 1)}}
\item{alternative}{Type of the alternative hypothesis in the test, one of \code{"two.sided"}, \code{"less"}, \code{"greater"}}
\item{method}{Description of the hypothesis test}
\item{data.name}{Name of the data set}
}
\description{
An object of class \code{"htest"} (i.e., hypothesis test) function which performs a hypothesis test of
uniformity of \code{Xp} points in the support interval \eqn{(a,b)}).

The support interval \eqn{(a,b)} is partitioned as \code{(b-a)*(0:nint)/nint}
where \code{nint=round(sqrt(nx),0)} and \code{nx} is number of \code{Xp} points, and the test is for testing the uniformity of \code{Xp}
points in the interval \eqn{(a,b)}.

The null hypothesis is uniformity of \code{Xp} points on \eqn{(a,b)}.
The alternative is deviation of distribution of \code{Xp} points from uniformity. The test is based on the (asymptotic) binomial
distribution of the domination number of PE-PCD for uniform 1D data in the partition intervals based on partition of \eqn{(a,b)}.

The function yields the test statistic, \eqn{p}-value for the corresponding
alternative, the confidence interval, estimate and null value for the parameter of interest (which is
\eqn{Pr(}domination number\eqn{\le 1)}), and method and name of the data set used.

Under the null hypothesis of uniformity of \code{Xp} points in the support interval, probability of success
(i.e., \eqn{Pr(}domination number\eqn{\le 1)}) equals to its expected value) and
\code{alternative} could be two-sided, or left-sided (i.e., data is accumulated around the end points of the partition
intervals of the support) or right-sided (i.e., data is accumulated around the centers of the partition intervals).

PE proximity region is constructed with the expansion parameter \eqn{r \ge 1} and centrality parameter \code{c} which yields
\eqn{M}-vertex regions. More precisely \eqn{M_c=a+c(b-a)} for the centrality parameter \code{c} and for a given \eqn{c \in (0,1)}, the
expansion parameter \eqn{r} is taken to be \eqn{1/\max(c,1-c)} which yields non-degenerate asymptotic distribution of the
domination number.

The test statistic is based on the binomial distribution, when success is defined as domination number being less than
or equal to 1 in the one interval case (i.e., number of failures is equal to number of times restricted domination number = 1
in the intervals).
That is, the test statistic is based on the domination number for \code{Xp} points inside the partition intervals
for the PE-PCD. For this approach to work, \code{Xp} must be large for each partition interval,
but 5 or more per partition interval seems to work in practice.

Probability of success is chosen in the following way for various parameter choices.
\code{asy.bin} is a logical argument for the use of asymptotic probability of success for the binomial distribution,
default is \code{asy.bin=FALSE}.  When \code{asy.bin=TRUE}, asymptotic probability of success for the binomial distribution is used.
When \code{asy.bin=FALSE}, the finite sample probability of success for the binomial distribution is used with number
of trials equals to expected number of \code{Xp} points per partition interval.
}
\examples{
\dontrun{
a<-0; b<-10; supp<-c(a,b)
c<-.4

r<-1/max(c,1-c)

#nx is number of X points (target) and ny is number of Y points (nontarget)
nx<-100; ny<-4;  #try also nx<-40; ny<-10 or nx<-1000; ny<-10;

set.seed(1)
Xp<-runif(nx,a,b)

PEdom.num.binom.test1Dint(Xp,supp,c,alt="t")
PEdom.num.binom.test1Dint(Xp,support.int = supp,c=c,alt="t")
PEdom.num.binom.test1Dint(Xp,supp,c,alt="l")
PEdom.num.binom.test1Dint(Xp,supp,c,alt="g")
PEdom.num.binom.test1Dint(Xp,supp,c,alt="t",asy.bin = TRUE)
}

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{PEdom.num.binom.test}}, \code{\link{PEdom.num1D}} and \code{\link{PEdom.num1Dnondeg}}
}
\author{
Elvan Ceyhan
}
