% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PropEdge1D.R
\name{IncMatPE1D}
\alias{IncMatPE1D}
\title{Incidence matrix for Proportional-Edge Proximity Catch Digraphs (PE-PCDs)
for 1D data - multiple interval case}
\usage{
IncMatPE1D(Xp, Yp, r, c = 0.5)
}
\arguments{
\item{Xp}{a set of 1D points which constitutes the vertices of the digraph.}

\item{Yp}{a set of 1D points which constitutes the end points of the intervals
that partition the real line.}

\item{r}{A positive real number which serves as the expansion parameter in PE proximity region;
must be \eqn{\ge 1}.}

\item{c}{A positive real number in \eqn{(0,1)} parameterizing the center inside middle intervals
with the default \code{c=.5}.
For the interval, \eqn{(a,b)}, the parameterized center is \eqn{M_c=a+c(b-a)}.}
}
\value{
Incidence matrix for the PE-PCD with vertices being 1D data set, \code{Xp},
and \code{Yp} determines the end points of the intervals (in the multi-interval case)
}
\description{
Returns the incidence matrix for the PE-PCD for a given 1D numerical data set, \code{Xp},
as the vertices of the digraph and \code{Yp} determines the end points of the intervals (in the multi-interval case).
Loops are allowed, so the diagonal entries are all equal to 1.

PE proximity region is constructed
with an expansion parameter \eqn{r \ge 1} and a centrality parameter \eqn{c \in (0,1)}.

See also (\insertCite{ceyhan:metrika-2012;textual}{pcds}).
}
\examples{
\dontrun{
r<-2
c<-.4
a<-0; b<-10;
nx<-10; ny<-4

set.seed(1)
Xp<-runif(nx,a,b)
Yp<-runif(ny,a,b)

IM<-IncMatPE1D(Xp,Yp,r,c)
IM

dom.greedy(IM)
IndUBdom(IM,6)
dom.exact(IM)
}

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{IncMatCS1D}}, \code{\link{IncMatPEtri}}, and \code{\link{IncMatPE}}
}
\author{
Elvan Ceyhan
}
