% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCDFunctions.r
\name{IncMatCStri}
\alias{IncMatCStri}
\title{Incidence matrix for Central Similarity Proximity Catch Digraphs (CS-PCDs) - one triangle case}
\usage{
IncMatCStri(dat, tri, t, M = c(1, 1, 1))
}
\arguments{
\item{dat}{A set of 2D points which constitute the vertices of CS-PCD.}

\item{tri}{Three 2D points, stacked row-wise, each row representing a vertex of the triangle.}

\item{t}{A positive real number which serves as the expansion parameter in CS proximity region.}

\item{M}{A 2D point in Cartesian coordinates or a 3D point in barycentric coordinates
which serves as a center in the interior of the triangle \code{tri};
default is \eqn{M=(1,1,1)} i.e., the center of mass of \code{tri}.}
}
\value{
Incidence matrix for the CS-PCD with vertices being 2D data set, \code{dat},
in the triangle \code{tri} with edge regions based on center \code{M}
}
\description{
Returns the incidence matrix for the CS-PCD whose vertices are the given 2D numerical data set, \code{dat},
in the triangle \code{tri}\eqn{=T(v=1,v=2,v=3)}.

CS proximity regions are constructed with respect to triangle \code{tri}
with expansion parameter \eqn{t>0} and edge regions are based on the center \eqn{M=(m_1,m_2)} in Cartesian coordinates
or \eqn{M=(\alpha,\beta,\gamma)} in barycentric coordinates in the interior of the triangle \code{tri};
default is \eqn{M=(1,1,1)} i.e., the center of mass of \code{tri}.
Loops are allowed, so the diagonal entries are all equal to 1.

See also (\insertCite{ceyhan:Phd-thesis,ceyhan:arc-density-CS,ceyhan:test2014;textual}{pcds}).
}
\examples{
A<-c(1,1); B<-c(2,0); C<-c(1.5,2);

Tr<-rbind(A,B,C);
n<-10

set.seed(1)
dat<-runif.tri(n,Tr)$g

M<-as.numeric(runif.tri(1,Tr)$g)  #try also M<-c(1.6,1.0)

IM<-IncMatCStri(dat,Tr,t=1.25,M)
IM
dom.greedy(IM)
dom.exact(IM)
IndUBdom(IM,3)

IncMatCStri(dat,Tr,t=1.5,M)
IncMatCStri(dat,Tr,t=2,M)

t<-2
IncMatCStri(dat,Tr,t,M)

dat.fr<-data.frame(a=dat)
IncMatCStri(dat.fr,Tr,t,M)

dat.fr<-data.frame(a=Tr)
IncMatCStri(dat,dat.fr,t,M)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{IncMatCSMT}}, \code{\link{IncMatPEtri}}, and  \code{\link{IncMatAStri}}
}
\author{
Elvan Ceyhan
}
