% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCDFunctions.r
\name{rverts.tri.cent.alt}
\alias{rverts.tri.cent.alt}
\title{The alternative function for the indices of the vertex regions in a triangle that contains the points
in a give data set}
\usage{
rverts.tri.cent.alt(Dt, tri, M)
}
\arguments{
\item{Dt}{A set of 2D points representing the set of data points for which indices of the vertex regions
containing them are to be determined.}

\item{tri}{Three 2D points, stacked row-wise, each row representing a vertex of the triangle.}

\item{M}{A 2D point in Cartesian coordinates or a 3D point in barycentric coordinates
which serves as a center in the interior of the triangle \code{tri} or the circumcenter of \code{tri}.}
}
\value{
A list with two elements
\item{rv}{Indices of the vertices whose regions contains points in \code{Dt}.}
\item{tri}{The vertices of the triangle, where row number corresponds to the vertex index in \code{rv}.}
}
\description{
An alternative function to the function \code{\link{rverts.tri.cent}}
}
\examples{
\dontrun{
A<-c(1,1); B<-c(2,0); C<-c(1.5,2);
Tr<-rbind(A,B,C);
M<-c(1.6,1.0)

P<-c(.4,.2)
rverts.tri.cent.alt(P,Tr,M)

P<-c(1.8,.5)
rverts.tri.cent.alt(P,Tr,M)

P<-c(1.5,1.6)
rverts.tri.cent.alt(P,Tr,M)

n<-10  #try also n<-20
set.seed(1)
dat<-runif.tri(n,Tr)$g

M<-c(1.6,1.0)  #try also M<-c(1.3,1.3)

rv<-rverts.tri.cent.alt(dat,Tr,M)
rv

Ds<-cp2e.tri(Tr,M)

Xlim<-range(Tr[,1])
Ylim<-range(Tr[,2])
xd<-Xlim[2]-Xlim[1]
yd<-Ylim[2]-Ylim[1]

plot(Tr,pch=".",xlab="",ylab="",axes=TRUE,xlim=Xlim+xd*c(-.05,.05),ylim=Ylim+yd*c(-.05,.05))
polygon(Tr)
points(dat,pch=".",col=1)
L<-rbind(M,M,M); R<-Ds
segments(L[,1], L[,2], R[,1], R[,2], lty=2)

xc<-Tr[,1]+c(-.03,.05,.05)
yc<-Tr[,2]+c(-.06,.02,.05)
txt.str<-c("rv=1","rv=2","rv=3")
text(xc,yc,txt.str)

txt<-rbind(M,Ds)
xc<-txt[,1]+c(.02,.04,-.03,0)
yc<-txt[,2]+c(.07,.03,.05,-.07)
txt.str<-c("M","D1","D2","D3")
text(xc,yc,txt.str)

text(dat,labels=factor(rv$rv))

P<-c(1.4,1.0)
rverts.tri.cent.alt(P,Tr,M)
rverts.tri.cent.alt(dat,Tr,M)

rverts.tri.cent.alt(rbind(dat,dat),Tr,M)

dat.fr<-data.frame(a=dat)
rverts.tri.cent.alt(dat.fr,Tr,M)

dat.fr<-data.frame(a=Tr)
rverts.tri.cent.alt(dat,dat.fr,M)
}

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{rverts.tri.cent}}
}
