% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCDFunctions.r
\name{re.bastri.cent}
\alias{re.bastri.cent}
\title{The index of the edge region in a basic triangle that contains a point}
\usage{
re.bastri.cent(pt, c1, c2, M)
}
\arguments{
\item{pt}{A 2D point for which \code{M}-edge region it resides in is to be determined in the
basic triangle \eqn{T_b}.}

\item{c1, c2}{Positive real numbers which constitute the upper vertex of the basic triangle (i.e., the vertex
adjacent to the shorter edges of \eqn{T_b}); \code{c1} must be in \eqn{[0,1/2]}, \eqn{c_2>0} and
\eqn{(1-c_1)^2+c_2^2 \le 1}.}

\item{M}{A 2D point in Cartesian coordinates or a 3D point in barycentric coordinates
which serves as a center in the interior of the basic triangle \eqn{T_b}.}
}
\value{
A list with three elements

\item{re}{Index of the \code{M}-edge region that contains point, \code{pt}  in the basic triangle \eqn{T_b}.}
\item{tri}{The vertices of the triangle, where row labels are A, B, and C
with edges are labeled as 3 for edge AB, 1 for edge BC, and 2 for edge AC.}
\item{desc}{Description of the edge labels}
}
\description{
Returns the index of the edge whose region contains point, \code{pt}, in
the basic triangle \eqn{T_b=T(A=(0,0),B=(1,0),C=(c_1,c_2))} and edge regions based on center
\eqn{M=(m_1,m_2)} in Cartesian coordinates or \eqn{M=(\alpha,\beta,\gamma)} in barycentric coordinates
in the interior of the basic triangle \eqn{T_b}.

Edges are labeled as 3 for edge AB, 1 for edge BC, and 2 for edge AC.
If the point, \code{pt}, is not inside \code{tri}, then the function yields \code{NA} as output.
Edge region 1 is the triangle \eqn{T(B,C,M)}, edge region 2 is \eqn{T(A,C,M)}, and edge region 3 is \eqn{T(A,B,M)}.
In the basic triangle \eqn{T_b} \code{c1} is in \eqn{[0,1/2]}, \eqn{c_2>0} and \eqn{(1-c_1)^2+c_2^2 \le 1}.

Any given triangle can be mapped to the basic triangle by a combination of rigid body motions
(i.e., translation, rotation and reflection) and scaling, preserving uniformity of the points in the
original triangle. Hence basic triangle is useful for simulation
studies under the uniformness hypothesis.

See also (\insertCite{ceyhan:Phd-thesis,ceyhan:comp-geo-2010,ceyhan:mcap2012,ceyhan:arc-density-CS;textual}{pcds}).
}
\examples{
c1<-.4; c2<-.6
A<-c(0,0); B<-c(1,0); C<-c(c1,c2);
Tb<-rbind(A,B,C);
M<-c(.6,.2)

P<-c(.4,.2)
re.bastri.cent(P,c1,c2,M)

P<-c(1.4,.2)
re.bastri.cent(P,c1,c2,M)

c1<-.5; c2<-.8
P<-c(.4,.2)
re.bastri.cent(P,c1,c2,M)

P<-c(.8,.2)
re.bastri.cent(P,c1,c2,M)

c1<-.4; c2<-.6
A<-c(0,0);B<-c(1,0);C<-c(c1,c2);
Tb<-rbind(A,B,C)

re.bastri.cent(A,c1,c2,M)
re.bastri.cent(B,c1,c2,M)
re.bastri.cent(C,c1,c2,M)
re.bastri.cent(M,c1,c2,M)

n<-10  #try also n<-20
dat<-runif.bastri(n,c1,c2)$g

M<-as.numeric(runif.bastri(1,c1,c2)$g)  #try also M<-c(.6,.2)

re<-vector()
for (i in 1:n)
  re<-c(re,re.bastri.cent(dat[i,],c1,c2,M)$re)
re

Xlim<-range(Tb[,1],dat[,1])
Ylim<-range(Tb[,2],dat[,2])
xd<-Xlim[2]-Xlim[1]
yd<-Ylim[2]-Ylim[1]

plot(Tb,xlab="",ylab="",axes=TRUE,pch=".",xlim=Xlim+xd*c(-.05,.05),ylim=Ylim+yd*c(-.05,.05))
points(dat,pch=".")
polygon(Tb)
L<-Tb; R<-rbind(M,M,M)
segments(L[,1], L[,2], R[,1], R[,2], lty=2)
text(dat,labels=factor(re))

txt<-rbind(Tb,M)
xc<-txt[,1]+c(-.03,.03,.02,0)
yc<-txt[,2]+c(.02,.02,.02,-.03)
txt.str<-c("A","B","C","M")
text(xc,yc,txt.str)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{re.triCM}}, \code{\link{re.tri.cent}},
\code{\link{re.bastri.cent}}, \code{\link{reTeCM}}, and \code{\link{redge.triCM}}
}
