% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCDFunctions.r
\name{plotCSregsInt}
\alias{plotCSregsInt}
\title{The plot of the Central Similarity (CS) Proximity Regions for a general interval
(vertices jittered along y-coordinate) - one interval case}
\usage{
plotCSregsInt(
  dat,
  t,
  c = 0.5,
  int,
  Jit = 0.1,
  main = "",
  xlab = "",
  ylab = "",
  xlim = NULL,
  ylim = NULL,
  centers = FALSE,
  ...
)
}
\arguments{
\item{dat}{A set of 1D points for which CS proximity regions are to be constructed.}

\item{t}{A positive real number which serves as the expansion parameter in CS proximity region.}

\item{c}{A positive real number in \eqn{(0,1)} parameterizing the center inside \eqn{int=(a,b)}.
For the interval, \eqn{int=(a,b)}, the parameterized center is \eqn{M_c=a+c(b-a)}; default=0.5.}

\item{int}{A vector of two real numbers representing an interval.}

\item{Jit}{A positive real number that determines the amount of jitter along the y-axis, default is 0.1 and
\code{dat} points are jittered according to \eqn{U(-Jit,Jit)} distribution along the y-axis where \code{Jit} equals to the range of \code{dat} and proximity region
 intervals multiplied by \code{Jit}).}

\item{main}{Title of the main heading of the plot.}

\item{xlab, ylab}{Titles for the x and y axes, respectively (default="" for both).}

\item{xlim, ylim}{Numeric vectors of length 2, giving the x- and y-coordinate ranges.}

\item{centers}{A logical argument, if \code{TRUE}, plot includes the centers of the intervals.
as vertical lines in the plot, else centers of the intervals are not plotted.}

\item{\dots}{Additional \code{plot} parameters.}
}
\value{
Plot of the CS proximity regions for 1D points in or outside the interval \code{int}
}
\description{
Plots the points in and outside of the interval \code{int} and also the CS proximity regions (which are also intervals).

CS proximity regions are constructed with expansion parameter \eqn{t>0} and centrality parameter \code{c} in \eqn{(0,1)}.
For better visualization, a uniform jitter from \eqn{U(-Jit,Jit)} (default for \eqn{Jit=.1} times range of proximity
regions and \code{dat}) is added to  the y-direction.

\code{centers} is a logical argument, if \code{TRUE}, plot includes the
centers of the intervals as vertical lines in the plot, else centers of the intervals are not plotted.

See also (\insertCite{ceyhan:revstat-2016;textual}{pcds}).
}
\examples{
c<-.4
t<-2
a<-0; b<-10; int<-c(a,b)

n<-10
xr<-range(a,b)
xf<-(xr[2]-xr[1])*.1
dat<-runif(n,a-xf,b+xf)  #try also dat<-runif(n,a-5,b+5)

plotCSregsInt(7,t,c,int)

plotCSregsInt(dat,t,c,int)

plotCSregsInt(17,t,c,int)
plotCSregsInt(1,t,c,int)
plotCSregsInt(4,t,c,int)

plotCSregsInt(-7,t,c,int)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{plotCSregsMI}}, \code{\link{plotPEregsInt}}, and \code{\link{plotPEregsMI}}
}
