% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCDFunctions.r
\name{PEdom1D}
\alias{PEdom1D}
\title{The domination number of Proportional Edge Proximity Catch Digraph (PE-PCD) for 1D data}
\usage{
PEdom1D(Xp, Yp, r, c = 0.5)
}
\arguments{
\item{Xp}{A set of 1D points which constitute the vertices of the PE-PCD.}

\item{Yp}{A set of 1D points which constitute the end points of the intervals which
partition the real line.}

\item{r}{A positive real number which serves as the expansion parameter in PE proximity region; must be \eqn{\ge 1}.}

\item{c}{A positive real number in \eqn{(0,1)} parameterizing the center inside \code{int} (default c=.5).}
}
\value{
A list with two elements
\item{dom.num}{Domination number of PE-PCD with vertex set=\code{Xp} and expansion parameter \eqn{r \ge 1} and
centrality parameter \code{c} in \eqn{(0,1)} }
\item{mds}{A minimum dominating set of PE-PCD with vertex set=\code{Xp} and expansion parameter \eqn{r \ge 1} and
centrality parameter \code{c} in \eqn{(0,1)} }
}
\description{
Returns the domination number of PE-PCD whose vertices are the 1D data set \code{Xp}.

\code{Yp} determines the end points of the intervals (i.e., partition the real line via intervalization).

PE proximity region is constructed with expansion parameter \eqn{r \ge 1} and centrality parameter \code{c} in \eqn{(0,1)}.
}
\examples{
a<-0; b<-10; int<-c(a,b)
c<-.4
r<-2

#nx is number of X points (target) and ny is number of Y points (nontarget)
nx<-20; ny<-4;  #try also nx<-40; ny<-10 or nx<-1000; ny<-10;

set.seed(1)
Xp<-runif(nx,a,b)
Yp<-runif(ny,a,b)

plotIntervals(Xp,Yp,main="Xp Points and Intervals Based on Yp Points")
plotPEregsMI(Xp,Yp,r,c,main="PE Proximity Regions for Xp points - Intervalization is by Yp Points")

PEdom1D(Xp,Yp,r,c)

PEdom1D(Xp,Yp,r,c=.25)
PEdom1D(Xp,Yp,r,c=.01)
PEdom1D(Xp,Yp,r=1.25,c)

}
\seealso{
\code{\link{PEdomMTnd}}
}
