% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCDFunctions.r
\name{ASarcdens.tri}
\alias{ASarcdens.tri}
\title{Arc density of Arc Slice Proximity Catch Digraphs (AS-PCDs) - one triangle case}
\usage{
ASarcdens.tri(Xp, tri, M = "CC", tri.cor = TRUE)
}
\arguments{
\item{Xp}{A set of 2D points which constitute the vertices of the AS-PCD}

\item{tri}{Three 2D points, stacked row-wise, each row representing a vertex of the triangle}

\item{M}{"CC" which stands for circumcenter of the triangle \code{tri} or a 2D point in Cartesian coordinates or
a 3D point in barycentric coordinates which serves as a center in the interior of \code{tri};
default is \code{M}="CC" i.e. the circumcenter of \code{tri}}

\item{tri.cor}{A logical argument for computing the arc density for only the points inside the triangle, \code{tri}
(default=\code{TRUE}), i.e., if \code{TRUE} only the induced digraph with the vertices inside \code{tri} are considered in the
computation of arc density}
}
\value{
Arc density of AS-PCD whose vertices are the 2D numerical data set, \code{Xp};
AS proximity regions are defined with respect to the triangle \code{tri} and CC-vertex regions.
}
\description{
Returns the arc density of AS-PCD whose vertex set is the given 2D numerical data set, \code{Xp},
(some of its members are) in the triangle \code{tri}.

AS proximity regions is defined with respect to \code{tri}
and vertex regions are defined with the center \code{M}="CC" for circumcenter of \code{tri};
or \eqn{M=(m_1,m_2)} in Cartesian coordinates or \eqn{M=(\alpha,\beta,\gamma)} in barycentric coordinates in the
interior of the triangle \code{tri}; default is \code{M}="CC" i.e. circumcenter of \code{tri}.
For the number of arcs, loops are not allowed so arcs are only possible for points inside \code{tri}
for this function.

\code{tri.cor} is a logical argument for triangle correction (default is \code{TRUE}),
if \code{TRUE}, only the points inside the triangle are considered (i.e., digraph induced by these vertices
are considered) in computing the arc density, otherwise all points are considered
(for the number of vertices in the denominator of arc density).

See also (\insertCite{ceyhan:Phd-thesis,ceyhan:comp-geo-2010,ceyhan:mcap2012;textual}{pcds}).
}
\examples{
A<-c(1,1); B<-c(2,0); C<-c(1.5,2);
Tr<-rbind(A,B,C);

set.seed(1)
n<-10  #try also n<-20

dat<-runif.tri(n,Tr)$g

M<-as.numeric(runif.tri(1,Tr)$g)  #try also M<-c(1.6,1.2)

NumArcsAStri(dat,Tr,M)
ASarcdens.tri(dat,Tr,M)
ASarcdens.tri(dat,Tr,M,tri.cor = FALSE)

ASarcdens.tri(dat,Tr,M)

dat.fr<-data.frame(a=dat)
ASarcdens.tri(dat.fr,Tr,M)

dat.fr<-data.frame(a=Tr)
ASarcdens.tri(dat,dat.fr,M)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{ASarcdens.tri}}, \code{\link{CSarcdens.tri}}, and \code{\link{NumArcsAStri}}
}
