% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CentSimUG2D.R
\name{num.edgesCStri}
\alias{num.edgesCStri}
\title{Number of edges in the underlying or reflexivity graphs of
Central Similarity Proximity Catch Digraphs (CS-PCDs) -
one triangle case}
\usage{
num.edgesCStri(
  Xp,
  tri,
  t,
  M = c(1, 1, 1),
  ugraph = c("underlying", "reflexivity")
)
}
\arguments{
\item{Xp}{A set of 2D points
which constitute the vertices of CS-PCD.}

\item{tri}{A \eqn{3 \times 2} matrix with each row
representing a vertex of the triangle.}

\item{t}{A positive real number
which serves as the expansion parameter in CS proximity region.}

\item{M}{A 2D point in Cartesian coordinates
or a 3D point in barycentric coordinates
which serves as a center in the interior of the triangle \code{tri};
default is \eqn{M=(1,1,1)}, i.e.,
the center of mass of \code{tri}.}

\item{ugraph}{The type of the graph based on CS-PCDs,
\code{"underlying"} is for the underlying graph, and \code{"reflexivity"} is for
the reflexivity graph (default is \code{"underlying"}).}
}
\value{
A \code{list} with the elements
\item{desc}{A short description of the output: number of edges
and quantities related to the triangle}
\item{und.graph}{Type of the graph as "Underlying" or "Reflexivity" for the CS-PCD}
\item{num.edges}{Number of edges of the underlying
or reflexivity graphs based on the CS-PCD
with vertices in the given triangle \code{tri}}
\item{num.in.tri}{Number of \code{Xp} points in the triangle, \code{tri}}
\item{ind.in.tri}{The vector of indices of the \code{Xp} points
that reside in the triangle}
\item{tess.points}{Tessellation points,
i.e., points on which the tessellation of the study region is performed,
here, tessellation is the support triangle.}
\item{vertices}{Vertices of the underlying or reflexivity graph, \code{Xp}.}
}
\description{
An object of class \code{"NumEdges"}.
Returns the number of edges of
the underlying or reflexivity graphs of
Central Similarity Proximity Catch Digraphs (CS-PCDs)
whose vertices are the
given 2D numerical data set, \code{Xp}
in a given triangle.
It also provides number of vertices
(i.e., number of data points inside the triangle)
and indices of the data points that reside in the triangle.

CS proximity region \eqn{N_{CS}(x,t)} is defined
with respect to the triangle, \code{tri}
with expansion parameter \eqn{t > 0} and edge regions are
based on the center \eqn{M=(m_1,m_2)} in Cartesian coordinates
or \eqn{M=(\alpha,\beta,\gamma)} in barycentric coordinates
in the interior of the triangle \code{tri};
default is \eqn{M=(1,1,1)}, i.e.,
the center of mass of \code{tri}.
For the number of edges, loops are not allowed,
so edges are only possible for points
inside the triangle \code{tri} for this function.

See also
(\insertCite{ceyhan:Phd-thesis,ceyhan:arc-density-CS;textual}{pcds.ugraph}).
}
\examples{
#\donttest{
A<-c(1,1); B<-c(2,0); C<-c(1.5,2);
Tr<-rbind(A,B,C);

n<-10
set.seed(1)
Xp<-pcds::runif.tri(n,Tr)$g

M<-as.numeric(pcds::runif.tri(1,Tr)$g)

Nedges = num.edgesCStri(Xp,Tr,t=1.5,M)
Nedges
summary(Nedges)
plot(Nedges)
#}

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{num.edgesCS}}, \code{\link{num.edgesAStri}},
\code{\link{num.edgesPEtri}}, and \code{\link[pcds]{num.arcsCStri}}
}
\author{
Elvan Ceyhan
}
