% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/staticGP.cate.R
\name{staticGP.cate}
\alias{staticGP.cate}
\title{Get conditional average treatment effect}
\usage{
staticGP.cate(
  jobid,
  x,
  control.tr,
  treat.tr,
  pr.values = NULL,
  token = NULL,
  use.cache = NULL
)
}
\arguments{
\item{jobid}{job id of the "staticGP".}

\item{x}{The name of a categorical variable which may have the heterogeneous treatment effect.}

\item{control.tr}{The value of the treatment variable as the reference group.}

\item{treat.tr}{The value of the treatment variable compared to the reference group.}

\item{pr.values}{An optional vector of user-defined values of c for PrCTE.}

\item{token}{Authentication token.}

\item{use.cache}{Use cached results (default True).}
}
\value{
Return jobid
}
\description{
Estimate the conditional average treatment effect of user-specified treatment groups.
}
\details{
The contrast of potential outcomes for the reference group and the treatment group is estimated at each value of x.
}
\note{
The conditional average treatment effect is estimated based on the sample data. The observations with missing covariates in the model are excluded. For the unspecified variables in the model, the original data is used to estimate the conditional average treatment effect.
}
