% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rpc_options.r
\name{rpc_options}
\alias{rpc_options}
\alias{rpcopt_set}
\alias{rpcopt_get}
\title{Set and Get Options for Remote Procedure Call}
\usage{
rpcopt_set(user = NULL, hostname = NULL, pport = NULL, exec.type = NULL,
  args = NULL, priv.key = NULL, priv.key.ppk = NULL)

rpcopt_get()
}
\arguments{
\item{user}{user id for logging to the server.}

\item{hostname}{the server ip or host name.}

\item{pport}{ssh port opened on the server.}

\item{exec.type}{either "ssh" or "plink".}

\item{args}{arguments to the \code{ssh} or \code{plink.exe}.}

\item{priv.key}{file name/path to the private key in OpenSSH format.}

\item{priv.key.ppk}{file name/path to the private key in PuTTY format.}
}
\value{
A list is returned.
}
\description{
Set and get default options of login information for \code{srpc()}.
}
\details{
\code{rpcopt_set()} is to alter default options of login information. 
The user defined options are set to \code{.pbd_env$RPC.LI}.
\code{rpcopt_get()} is to get default options of login information
from \code{.pbd_env$RPC.LI}.
}
\examples{
\dontrun{
library(pbdRPC, quietly = TRUE)
rpcopt_set(user = "snoweye", hostname = "192.168.56.101")

rpcopt_get()
}

}
\seealso{
\code{\link{rpc}()}, \code{\link{srpc}()}.
}
