% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paws.R
\name{organizations}
\alias{organizations}
\title{AWS Organizations}
\usage{
organizations(
  config = list(),
  credentials = list(),
  endpoint = NULL,
  region = NULL
)
}
\arguments{
\item{config}{Optional configuration of credentials, endpoint, and/or region.
\itemize{
\item{\strong{credentials}:} {\itemize{
\item{\strong{creds}:} {\itemize{
\item{\strong{access_key_id}:} {AWS access key ID}
\item{\strong{secret_access_key}:} {AWS secret access key}
\item{\strong{session_token}:} {AWS temporary session token}
}}
\item{\strong{profile}:} {The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}:} {Set anonymous credentials.}
\item{\strong{endpoint}:} {The complete URL to use for the constructed client.}
\item{\strong{region}:} {The AWS Region used in instantiating the client.}
}}
\item{\strong{close_connection}:} {Immediately close all HTTP connections.}
\item{\strong{timeout}:} {The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
\item{\strong{s3_force_path_style}:} {Set this to \code{true} to force the request to use path-style addressing, i.e. \verb{http://s3.amazonaws.com/BUCKET/KEY}.}
\item{\strong{sts_regional_endpoint}:} {Set sts regional endpoint resolver to regional or legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}
}}

\item{credentials}{Optional credentials shorthand for the config parameter
\itemize{
\item{\strong{creds}:} {\itemize{
\item{\strong{access_key_id}:} {AWS access key ID}
\item{\strong{secret_access_key}:} {AWS secret access key}
\item{\strong{session_token}:} {AWS temporary session token}
}}
\item{\strong{profile}:} {The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}:} {Set anonymous credentials.}
}}

\item{endpoint}{Optional shorthand for complete URL to use for the constructed client.}

\item{region}{Optional shorthand for AWS Region used in instantiating the client.}
}
\value{
A client for the service. You can call the service's operations using
syntax like \code{svc$operation(...)}, where \code{svc} is the name you've assigned
to the client. The available operations are listed in the
Operations section.
}
\description{
Organizations is a web service that enables you to consolidate your
multiple Amazon Web Services accounts into an \emph{organization} and
centrally manage your accounts and their resources.

This guide provides descriptions of the Organizations operations. For
more information about using this service, see the \href{https://docs.aws.amazon.com/organizations/latest/userguide/orgs_introduction.html}{Organizations User Guide}.

\strong{Support and feedback for Organizations}

We welcome your feedback. Send your comments to
\href{mailto:feedback-awsorganizations@amazon.com}{feedback-awsorganizations@amazon.com} or post your feedback and
questions in the Organizations support forum. For more information about
the Amazon Web Services support forums, see Forums Help.

\strong{Endpoint to call When using the CLI or the Amazon Web Services SDK}

For the current release of Organizations, specify the \code{us-east-1} region
for all Amazon Web Services API and CLI calls made from the commercial
Amazon Web Services Regions outside of China. If calling from one of the
Amazon Web Services Regions in China, then specify \code{cn-northwest-1}. You
can do this in the CLI by using these parameters and commands:
\itemize{
\item Use the following parameter with each command to specify both the
endpoint and its region:

\verb{--endpoint-url https://organizations.us-east-1.amazonaws.com}
\emph{(from commercial Amazon Web Services Regions outside of China)}

or

\verb{--endpoint-url https://organizations.cn-northwest-1.amazonaws.com.cn}
\emph{(from Amazon Web Services Regions in China)}
\item Use the default endpoint, but configure your default region with
this command:

\verb{aws configure set default.region us-east-1} \emph{(from commercial
Amazon Web Services Regions outside of China)}

or

\verb{aws configure set default.region cn-northwest-1} \emph{(from Amazon Web
Services Regions in China)}
\item Use the following parameter with each command to specify the
endpoint:

\verb{--region us-east-1} \emph{(from commercial Amazon Web Services Regions
outside of China)}

or

\verb{--region cn-northwest-1} \emph{(from Amazon Web Services Regions in
China)}
}

\strong{Recording API Requests}

Organizations supports CloudTrail, a service that records Amazon Web
Services API calls for your Amazon Web Services account and delivers log
files to an Amazon S3 bucket. By using information collected by
CloudTrail, you can determine which requests the Organizations service
received, who made the request and when, and so on. For more about
Organizations and its support for CloudTrail, see \href{https://docs.aws.amazon.com/organizations/latest/userguide/#orgs_cloudtrail-integration}{Logging Organizations API calls with CloudTrail}
in the \emph{Organizations User Guide}. To learn more about CloudTrail,
including how to turn it on and find your log files, see the \href{https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-user-guide.html}{CloudTrail User Guide}.
}
\section{Service syntax}{


\if{html}{\out{<div class="sourceCode">}}\preformatted{svc <- organizations(
  config = list(
    credentials = list(
      creds = list(
        access_key_id = "string",
        secret_access_key = "string",
        session_token = "string"
      ),
      profile = "string",
      anonymous = "logical"
    ),
    endpoint = "string",
    region = "string",
    close_connection = "logical",
    timeout = "numeric",
    s3_force_path_style = "logical",
    sts_regional_endpoint = "string"
  ),
  credentials = list(
    creds = list(
      access_key_id = "string",
      secret_access_key = "string",
      session_token = "string"
    ),
    profile = "string",
    anonymous = "logical"
  ),
  endpoint = "string",
  region = "string"
)
}\if{html}{\out{</div>}}
}

\section{Operations}{

\tabular{ll}{
\link[paws.management:organizations_accept_handshake]{accept_handshake} \tab Sends a response to the originator of a handshake agreeing to the action proposed by the handshake request\cr
\link[paws.management:organizations_attach_policy]{attach_policy} \tab Attaches a policy to a root, an organizational unit (OU), or an individual account\cr
\link[paws.management:organizations_cancel_handshake]{cancel_handshake} \tab Cancels a handshake\cr
\link[paws.management:organizations_close_account]{close_account} \tab Closes an Amazon Web Services member account within an organization\cr
\link[paws.management:organizations_create_account]{create_account} \tab Creates an Amazon Web Services account that is automatically a member of the organization whose credentials made the request\cr
\link[paws.management:organizations_create_gov_cloud_account]{create_gov_cloud_account} \tab This action is available if all of the following are true:\cr
\link[paws.management:organizations_create_organization]{create_organization} \tab Creates an Amazon Web Services organization\cr
\link[paws.management:organizations_create_organizational_unit]{create_organizational_unit} \tab Creates an organizational unit (OU) within a root or parent OU\cr
\link[paws.management:organizations_create_policy]{create_policy} \tab Creates a policy of a specified type that you can attach to a root, an organizational unit (OU), or an individual Amazon Web Services account\cr
\link[paws.management:organizations_decline_handshake]{decline_handshake} \tab Declines a handshake request\cr
\link[paws.management:organizations_delete_organization]{delete_organization} \tab Deletes the organization\cr
\link[paws.management:organizations_delete_organizational_unit]{delete_organizational_unit} \tab Deletes an organizational unit (OU) from a root or another OU\cr
\link[paws.management:organizations_delete_policy]{delete_policy} \tab Deletes the specified policy from your organization\cr
\link[paws.management:organizations_delete_resource_policy]{delete_resource_policy} \tab Deletes the resource policy from your organization\cr
\link[paws.management:organizations_deregister_delegated_administrator]{deregister_delegated_administrator} \tab Removes the specified member Amazon Web Services account as a delegated administrator for the specified Amazon Web Services service\cr
\link[paws.management:organizations_describe_account]{describe_account} \tab Retrieves Organizations-related information about the specified account\cr
\link[paws.management:organizations_describe_create_account_status]{describe_create_account_status} \tab Retrieves the current status of an asynchronous request to create an account\cr
\link[paws.management:organizations_describe_effective_policy]{describe_effective_policy} \tab Returns the contents of the effective policy for specified policy type and account\cr
\link[paws.management:organizations_describe_handshake]{describe_handshake} \tab Retrieves information about a previously requested handshake\cr
\link[paws.management:organizations_describe_organization]{describe_organization} \tab Retrieves information about the organization that the user's account belongs to\cr
\link[paws.management:organizations_describe_organizational_unit]{describe_organizational_unit} \tab Retrieves information about an organizational unit (OU)\cr
\link[paws.management:organizations_describe_policy]{describe_policy} \tab Retrieves information about a policy\cr
\link[paws.management:organizations_describe_resource_policy]{describe_resource_policy} \tab Retrieves information about a resource policy\cr
\link[paws.management:organizations_detach_policy]{detach_policy} \tab Detaches a policy from a target root, organizational unit (OU), or account\cr
\link[paws.management:organizations_disable_aws_service_access]{disable_aws_service_access} \tab Disables the integration of an Amazon Web Services service (the service that is specified by ServicePrincipal) with Organizations\cr
\link[paws.management:organizations_disable_policy_type]{disable_policy_type} \tab Disables an organizational policy type in a root\cr
\link[paws.management:organizations_enable_all_features]{enable_all_features} \tab Enables all features in an organization\cr
\link[paws.management:organizations_enable_aws_service_access]{enable_aws_service_access} \tab Enables the integration of an Amazon Web Services service (the service that is specified by ServicePrincipal) with Organizations\cr
\link[paws.management:organizations_enable_policy_type]{enable_policy_type} \tab Enables a policy type in a root\cr
\link[paws.management:organizations_invite_account_to_organization]{invite_account_to_organization} \tab Sends an invitation to another account to join your organization as a member account\cr
\link[paws.management:organizations_leave_organization]{leave_organization} \tab Removes a member account from its parent organization\cr
\link[paws.management:organizations_list_accounts]{list_accounts} \tab Lists all the accounts in the organization\cr
\link[paws.management:organizations_list_accounts_for_parent]{list_accounts_for_parent} \tab Lists the accounts in an organization that are contained by the specified target root or organizational unit (OU)\cr
\link[paws.management:organizations_list_aws_service_access_for_organization]{list_aws_service_access_for_organization} \tab Returns a list of the Amazon Web Services services that you enabled to integrate with your organization\cr
\link[paws.management:organizations_list_children]{list_children} \tab Lists all of the organizational units (OUs) or accounts that are contained in the specified parent OU or root\cr
\link[paws.management:organizations_list_create_account_status]{list_create_account_status} \tab Lists the account creation requests that match the specified status that is currently being tracked for the organization\cr
\link[paws.management:organizations_list_delegated_administrators]{list_delegated_administrators} \tab Lists the Amazon Web Services accounts that are designated as delegated administrators in this organization\cr
\link[paws.management:organizations_list_delegated_services_for_account]{list_delegated_services_for_account} \tab List the Amazon Web Services services for which the specified account is a delegated administrator\cr
\link[paws.management:organizations_list_handshakes_for_account]{list_handshakes_for_account} \tab Lists the current handshakes that are associated with the account of the requesting user\cr
\link[paws.management:organizations_list_handshakes_for_organization]{list_handshakes_for_organization} \tab Lists the handshakes that are associated with the organization that the requesting user is part of\cr
\link[paws.management:organizations_list_organizational_units_for_parent]{list_organizational_units_for_parent} \tab Lists the organizational units (OUs) in a parent organizational unit or root\cr
\link[paws.management:organizations_list_parents]{list_parents} \tab Lists the root or organizational units (OUs) that serve as the immediate parent of the specified child OU or account\cr
\link[paws.management:organizations_list_policies]{list_policies} \tab Retrieves the list of all policies in an organization of a specified type\cr
\link[paws.management:organizations_list_policies_for_target]{list_policies_for_target} \tab Lists the policies that are directly attached to the specified target root, organizational unit (OU), or account\cr
\link[paws.management:organizations_list_roots]{list_roots} \tab Lists the roots that are defined in the current organization\cr
\link[paws.management:organizations_list_tags_for_resource]{list_tags_for_resource} \tab Lists tags that are attached to the specified resource\cr
\link[paws.management:organizations_list_targets_for_policy]{list_targets_for_policy} \tab Lists all the roots, organizational units (OUs), and accounts that the specified policy is attached to\cr
\link[paws.management:organizations_move_account]{move_account} \tab Moves an account from its current source parent root or organizational unit (OU) to the specified destination parent root or OU\cr
\link[paws.management:organizations_put_resource_policy]{put_resource_policy} \tab Creates or updates a resource policy\cr
\link[paws.management:organizations_register_delegated_administrator]{register_delegated_administrator} \tab Enables the specified member account to administer the Organizations features of the specified Amazon Web Services service\cr
\link[paws.management:organizations_remove_account_from_organization]{remove_account_from_organization} \tab Removes the specified account from the organization\cr
\link[paws.management:organizations_tag_resource]{tag_resource} \tab Adds one or more tags to the specified resource\cr
\link[paws.management:organizations_untag_resource]{untag_resource} \tab Removes any tags with the specified keys from the specified resource\cr
\link[paws.management:organizations_update_organizational_unit]{update_organizational_unit} \tab Renames the specified organizational unit (OU)\cr
\link[paws.management:organizations_update_policy]{update_policy} \tab Updates an existing policy with a new name, description, or content
}
}

\examples{
\dontrun{
svc <- organizations()
# Bill is the owner of an organization, and he invites Juan's account
# (222222222222) to join his organization. The following example shows
# Juan's account accepting the handshake and thus agreeing to the
# invitation.
svc$accept_handshake(
  HandshakeId = "h-examplehandshakeid111"
)
}

}
