% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paws.R
\name{braket}
\alias{braket}
\title{Braket}
\usage{
braket(config = list(), credentials = list(), endpoint = NULL, region = NULL)
}
\arguments{
\item{config}{Optional configuration of credentials, endpoint, and/or region.
\itemize{
\item{\strong{credentials}:} {\itemize{
\item{\strong{creds}:} {\itemize{
\item{\strong{access_key_id}:} {AWS access key ID}
\item{\strong{secret_access_key}:} {AWS secret access key}
\item{\strong{session_token}:} {AWS temporary session token}
}}
\item{\strong{profile}:} {The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}:} {Set anonymous credentials.}
\item{\strong{endpoint}:} {The complete URL to use for the constructed client.}
\item{\strong{region}:} {The AWS Region used in instantiating the client.}
}}
\item{\strong{close_connection}:} {Immediately close all HTTP connections.}
\item{\strong{timeout}:} {The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
\item{\strong{s3_force_path_style}:} {Set this to \code{true} to force the request to use path-style addressing, i.e. \verb{http://s3.amazonaws.com/BUCKET/KEY}.}
\item{\strong{sts_regional_endpoint}:} {Set sts regional endpoint resolver to regional or legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}
}}

\item{credentials}{Optional credentials shorthand for the config parameter
\itemize{
\item{\strong{creds}:} {\itemize{
\item{\strong{access_key_id}:} {AWS access key ID}
\item{\strong{secret_access_key}:} {AWS secret access key}
\item{\strong{session_token}:} {AWS temporary session token}
}}
\item{\strong{profile}:} {The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}:} {Set anonymous credentials.}
}}

\item{endpoint}{Optional shorthand for complete URL to use for the constructed client.}

\item{region}{Optional shorthand for AWS Region used in instantiating the client.}
}
\value{
A client for the service. You can call the service's operations using
syntax like \code{svc$operation(...)}, where \code{svc} is the name you've assigned
to the client. The available operations are listed in the
Operations section.
}
\description{
The Amazon Braket API Reference provides information about the
operations and structures supported in Amazon Braket.

Additional Resources:
\itemize{
\item \href{https://docs.aws.amazon.com/braket/latest/developerguide/what-is-braket.html}{Amazon Braket Developer Guide}
}
}
\section{Service syntax}{


\if{html}{\out{<div class="sourceCode">}}\preformatted{svc <- braket(
  config = list(
    credentials = list(
      creds = list(
        access_key_id = "string",
        secret_access_key = "string",
        session_token = "string"
      ),
      profile = "string",
      anonymous = "logical"
    ),
    endpoint = "string",
    region = "string",
    close_connection = "logical",
    timeout = "numeric",
    s3_force_path_style = "logical",
    sts_regional_endpoint = "string"
  ),
  credentials = list(
    creds = list(
      access_key_id = "string",
      secret_access_key = "string",
      session_token = "string"
    ),
    profile = "string",
    anonymous = "logical"
  ),
  endpoint = "string",
  region = "string"
)
}\if{html}{\out{</div>}}
}

\section{Operations}{

\tabular{ll}{
\link[paws.compute:braket_cancel_job]{cancel_job} \tab Cancels an Amazon Braket job\cr
\link[paws.compute:braket_cancel_quantum_task]{cancel_quantum_task} \tab Cancels the specified task\cr
\link[paws.compute:braket_create_job]{create_job} \tab Creates an Amazon Braket job\cr
\link[paws.compute:braket_create_quantum_task]{create_quantum_task} \tab Creates a quantum task\cr
\link[paws.compute:braket_get_device]{get_device} \tab Retrieves the devices available in Amazon Braket\cr
\link[paws.compute:braket_get_job]{get_job} \tab Retrieves the specified Amazon Braket job\cr
\link[paws.compute:braket_get_quantum_task]{get_quantum_task} \tab Retrieves the specified quantum task\cr
\link[paws.compute:braket_list_tags_for_resource]{list_tags_for_resource} \tab Shows the tags associated with this resource\cr
\link[paws.compute:braket_search_devices]{search_devices} \tab Searches for devices using the specified filters\cr
\link[paws.compute:braket_search_jobs]{search_jobs} \tab Searches for Amazon Braket jobs that match the specified filter values\cr
\link[paws.compute:braket_search_quantum_tasks]{search_quantum_tasks} \tab Searches for tasks that match the specified filter values\cr
\link[paws.compute:braket_tag_resource]{tag_resource} \tab Add a tag to the specified resource\cr
\link[paws.compute:braket_untag_resource]{untag_resource} \tab Remove tags from a resource
}
}

\examples{
\dontrun{
svc <- braket()
svc$cancel_job(
  Foo = 123
)
}

}
