% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paws.R
\name{sagemaker}
\alias{sagemaker}
\title{Amazon SageMaker Service}
\usage{
sagemaker(config = list())
}
\arguments{
\item{config}{Optional configuration of credentials, endpoint, and/or region.}
}
\description{
Provides APIs for creating and managing Amazon SageMaker resources.

Other Resources:
\itemize{
\item \href{https://docs.aws.amazon.com/sagemaker/latest/dg/whatis.html#first-time-user}{Amazon SageMaker Developer Guide}
\item \href{https://docs.aws.amazon.com/augmented-ai/2019-11-07/APIReference/Welcome.html}{Amazon Augmented AI Runtime API Reference}
}
}
\section{Service syntax}{
\preformatted{svc <- sagemaker(
  config = list(
    credentials = list(
      creds = list(
        access_key_id = "string",
        secret_access_key = "string",
        session_token = "string"
      ),
      profile = "string"
    ),
    endpoint = "string",
    region = "string"
  )
)
}
}

\section{Operations}{

\tabular{ll}{
\link[=sagemaker_add_tags]{add_tags} \tab Adds or overwrites one or more tags for the specified Amazon SageMaker resource \cr
\link[=sagemaker_associate_trial_component]{associate_trial_component} \tab Associates a trial component with a trial \cr
\link[=sagemaker_create_algorithm]{create_algorithm} \tab Create a machine learning algorithm that you can use in Amazon SageMaker and list in the AWS Marketplace \cr
\link[=sagemaker_create_app]{create_app} \tab Creates a running App for the specified UserProfile \cr
\link[=sagemaker_create_auto_ml_job]{create_auto_ml_job} \tab Creates an AutoPilot job \cr
\link[=sagemaker_create_code_repository]{create_code_repository} \tab Creates a Git repository as a resource in your Amazon SageMaker account \cr
\link[=sagemaker_create_compilation_job]{create_compilation_job} \tab Starts a model compilation job \cr
\link[=sagemaker_create_domain]{create_domain} \tab Creates a Domain used by SageMaker Studio \cr
\link[=sagemaker_create_endpoint]{create_endpoint} \tab Creates an endpoint using the endpoint configuration specified in the request \cr
\link[=sagemaker_create_endpoint_config]{create_endpoint_config} \tab Creates an endpoint configuration that Amazon SageMaker hosting services uses to deploy models \cr
\link[=sagemaker_create_experiment]{create_experiment} \tab Creates an Amazon SageMaker \emph{experiment} \cr
\link[=sagemaker_create_flow_definition]{create_flow_definition} \tab Creates a flow definition \cr
\link[=sagemaker_create_human_task_ui]{create_human_task_ui} \tab Defines the settings you will use for the human review workflow user interface \cr
\link[=sagemaker_create_hyper_parameter_tuning_job]{create_hyper_parameter_tuning_job} \tab Starts a hyperparameter tuning job \cr
\link[=sagemaker_create_labeling_job]{create_labeling_job} \tab Creates a job that uses workers to label the data objects in your input dataset \cr
\link[=sagemaker_create_model]{create_model} \tab Creates a model in Amazon SageMaker \cr
\link[=sagemaker_create_model_package]{create_model_package} \tab Creates a model package that you can use to create Amazon SageMaker models or list on AWS Marketplace \cr
\link[=sagemaker_create_monitoring_schedule]{create_monitoring_schedule} \tab Creates a schedule that regularly starts Amazon SageMaker Processing Jobs to monitor the data captured for an Amazon SageMaker Endoint \cr
\link[=sagemaker_create_notebook_instance]{create_notebook_instance} \tab Creates an Amazon SageMaker notebook instance \cr
\link[=sagemaker_create_notebook_instance_lifecycle_config]{create_notebook_instance_lifecycle_config} \tab Creates a lifecycle configuration that you can associate with a notebook instance \cr
\link[=sagemaker_create_presigned_domain_url]{create_presigned_domain_url} \tab Creates a URL for a specified UserProfile in a Domain \cr
\link[=sagemaker_create_presigned_notebook_instance_url]{create_presigned_notebook_instance_url} \tab Returns a URL that you can use to connect to the Jupyter server from a notebook instance \cr
\link[=sagemaker_create_processing_job]{create_processing_job} \tab Creates a processing job \cr
\link[=sagemaker_create_training_job]{create_training_job} \tab Starts a model training job \cr
\link[=sagemaker_create_transform_job]{create_transform_job} \tab Starts a transform job \cr
\link[=sagemaker_create_trial]{create_trial} \tab Creates an Amazon SageMaker \emph{trial} \cr
\link[=sagemaker_create_trial_component]{create_trial_component} \tab Creates a \emph{trial component}, which is a stage of a machine learning \emph{trial} \cr
\link[=sagemaker_create_user_profile]{create_user_profile} \tab Creates a user profile \cr
\link[=sagemaker_create_workteam]{create_workteam} \tab Creates a new work team for labeling your data \cr
\link[=sagemaker_delete_algorithm]{delete_algorithm} \tab Removes the specified algorithm from your account \cr
\link[=sagemaker_delete_app]{delete_app} \tab Used to stop and delete an app \cr
\link[=sagemaker_delete_code_repository]{delete_code_repository} \tab Deletes the specified Git repository from your account \cr
\link[=sagemaker_delete_domain]{delete_domain} \tab Used to delete a domain \cr
\link[=sagemaker_delete_endpoint]{delete_endpoint} \tab Deletes an endpoint \cr
\link[=sagemaker_delete_endpoint_config]{delete_endpoint_config} \tab Deletes an endpoint configuration \cr
\link[=sagemaker_delete_experiment]{delete_experiment} \tab Deletes an Amazon SageMaker experiment \cr
\link[=sagemaker_delete_flow_definition]{delete_flow_definition} \tab Deletes the specified flow definition \cr
\link[=sagemaker_delete_human_task_ui]{delete_human_task_ui} \tab Use this operation to delete a worker task template (HumanTaskUi) \cr
\link[=sagemaker_delete_model]{delete_model} \tab Deletes a model \cr
\link[=sagemaker_delete_model_package]{delete_model_package} \tab Deletes a model package \cr
\link[=sagemaker_delete_monitoring_schedule]{delete_monitoring_schedule} \tab Deletes a monitoring schedule \cr
\link[=sagemaker_delete_notebook_instance]{delete_notebook_instance} \tab Deletes an Amazon SageMaker notebook instance \cr
\link[=sagemaker_delete_notebook_instance_lifecycle_config]{delete_notebook_instance_lifecycle_config} \tab Deletes a notebook instance lifecycle configuration \cr
\link[=sagemaker_delete_tags]{delete_tags} \tab Deletes the specified tags from an Amazon SageMaker resource \cr
\link[=sagemaker_delete_trial]{delete_trial} \tab Deletes the specified trial \cr
\link[=sagemaker_delete_trial_component]{delete_trial_component} \tab Deletes the specified trial component \cr
\link[=sagemaker_delete_user_profile]{delete_user_profile} \tab Deletes a user profile \cr
\link[=sagemaker_delete_workteam]{delete_workteam} \tab Deletes an existing work team \cr
\link[=sagemaker_describe_algorithm]{describe_algorithm} \tab Returns a description of the specified algorithm that is in your account \cr
\link[=sagemaker_describe_app]{describe_app} \tab Describes the app \cr
\link[=sagemaker_describe_auto_ml_job]{describe_auto_ml_job} \tab Returns information about an Amazon SageMaker job \cr
\link[=sagemaker_describe_code_repository]{describe_code_repository} \tab Gets details about the specified Git repository \cr
\link[=sagemaker_describe_compilation_job]{describe_compilation_job} \tab Returns information about a model compilation job \cr
\link[=sagemaker_describe_domain]{describe_domain} \tab The description of the domain \cr
\link[=sagemaker_describe_endpoint]{describe_endpoint} \tab Returns the description of an endpoint \cr
\link[=sagemaker_describe_endpoint_config]{describe_endpoint_config} \tab Returns the description of an endpoint configuration created using the CreateEndpointConfig API \cr
\link[=sagemaker_describe_experiment]{describe_experiment} \tab Provides a list of an experiment's properties \cr
\link[=sagemaker_describe_flow_definition]{describe_flow_definition} \tab Returns information about the specified flow definition \cr
\link[=sagemaker_describe_human_task_ui]{describe_human_task_ui} \tab Returns information about the requested human task user interface (worker task template) \cr
\link[=sagemaker_describe_hyper_parameter_tuning_job]{describe_hyper_parameter_tuning_job} \tab Gets a description of a hyperparameter tuning job \cr
\link[=sagemaker_describe_labeling_job]{describe_labeling_job} \tab Gets information about a labeling job \cr
\link[=sagemaker_describe_model]{describe_model} \tab Describes a model that you created using the CreateModel API \cr
\link[=sagemaker_describe_model_package]{describe_model_package} \tab Returns a description of the specified model package, which is used to create Amazon SageMaker models or list them on AWS Marketplace \cr
\link[=sagemaker_describe_monitoring_schedule]{describe_monitoring_schedule} \tab Describes the schedule for a monitoring job \cr
\link[=sagemaker_describe_notebook_instance]{describe_notebook_instance} \tab Returns information about a notebook instance \cr
\link[=sagemaker_describe_notebook_instance_lifecycle_config]{describe_notebook_instance_lifecycle_config} \tab Returns a description of a notebook instance lifecycle configuration \cr
\link[=sagemaker_describe_processing_job]{describe_processing_job} \tab Returns a description of a processing job \cr
\link[=sagemaker_describe_subscribed_workteam]{describe_subscribed_workteam} \tab Gets information about a work team provided by a vendor \cr
\link[=sagemaker_describe_training_job]{describe_training_job} \tab Returns information about a training job \cr
\link[=sagemaker_describe_transform_job]{describe_transform_job} \tab Returns information about a transform job \cr
\link[=sagemaker_describe_trial]{describe_trial} \tab Provides a list of a trial's properties \cr
\link[=sagemaker_describe_trial_component]{describe_trial_component} \tab Provides a list of a trials component's properties \cr
\link[=sagemaker_describe_user_profile]{describe_user_profile} \tab Describes a user profile \cr
\link[=sagemaker_describe_workforce]{describe_workforce} \tab Lists private workforce information, including workforce name, Amazon Resource Name (ARN), and, if applicable, allowed IP address ranges (CIDRs) \cr
\link[=sagemaker_describe_workteam]{describe_workteam} \tab Gets information about a specific work team \cr
\link[=sagemaker_disassociate_trial_component]{disassociate_trial_component} \tab Disassociates a trial component from a trial \cr
\link[=sagemaker_get_search_suggestions]{get_search_suggestions} \tab An auto-complete API for the search functionality in the Amazon SageMaker console \cr
\link[=sagemaker_list_algorithms]{list_algorithms} \tab Lists the machine learning algorithms that have been created \cr
\link[=sagemaker_list_apps]{list_apps} \tab Lists apps \cr
\link[=sagemaker_list_auto_ml_jobs]{list_auto_ml_jobs} \tab Request a list of jobs \cr
\link[=sagemaker_list_candidates_for_auto_ml_job]{list_candidates_for_auto_ml_job} \tab List the Candidates created for the job \cr
\link[=sagemaker_list_code_repositories]{list_code_repositories} \tab Gets a list of the Git repositories in your account \cr
\link[=sagemaker_list_compilation_jobs]{list_compilation_jobs} \tab Lists model compilation jobs that satisfy various filters \cr
\link[=sagemaker_list_domains]{list_domains} \tab Lists the domains \cr
\link[=sagemaker_list_endpoint_configs]{list_endpoint_configs} \tab Lists endpoint configurations \cr
\link[=sagemaker_list_endpoints]{list_endpoints} \tab Lists endpoints \cr
\link[=sagemaker_list_experiments]{list_experiments} \tab Lists all the experiments in your account \cr
\link[=sagemaker_list_flow_definitions]{list_flow_definitions} \tab Returns information about the flow definitions in your account \cr
\link[=sagemaker_list_human_task_uis]{list_human_task_uis} \tab Returns information about the human task user interfaces in your account \cr
\link[=sagemaker_list_hyper_parameter_tuning_jobs]{list_hyper_parameter_tuning_jobs} \tab Gets a list of HyperParameterTuningJobSummary objects that describe the hyperparameter tuning jobs launched in your account \cr
\link[=sagemaker_list_labeling_jobs]{list_labeling_jobs} \tab Gets a list of labeling jobs \cr
\link[=sagemaker_list_labeling_jobs_for_workteam]{list_labeling_jobs_for_workteam} \tab Gets a list of labeling jobs assigned to a specified work team \cr
\link[=sagemaker_list_model_packages]{list_model_packages} \tab Lists the model packages that have been created \cr
\link[=sagemaker_list_models]{list_models} \tab Lists models created with the CreateModel API \cr
\link[=sagemaker_list_monitoring_executions]{list_monitoring_executions} \tab Returns list of all monitoring job executions \cr
\link[=sagemaker_list_monitoring_schedules]{list_monitoring_schedules} \tab Returns list of all monitoring schedules \cr
\link[=sagemaker_list_notebook_instance_lifecycle_configs]{list_notebook_instance_lifecycle_configs} \tab Lists notebook instance lifestyle configurations created with the CreateNotebookInstanceLifecycleConfig API \cr
\link[=sagemaker_list_notebook_instances]{list_notebook_instances} \tab Returns a list of the Amazon SageMaker notebook instances in the requester's account in an AWS Region \cr
\link[=sagemaker_list_processing_jobs]{list_processing_jobs} \tab Lists processing jobs that satisfy various filters \cr
\link[=sagemaker_list_subscribed_workteams]{list_subscribed_workteams} \tab Gets a list of the work teams that you are subscribed to in the AWS Marketplace \cr
\link[=sagemaker_list_tags]{list_tags} \tab Returns the tags for the specified Amazon SageMaker resource \cr
\link[=sagemaker_list_training_jobs]{list_training_jobs} \tab Lists training jobs \cr
\link[=sagemaker_list_training_jobs_for_hyper_parameter_tuning_job]{list_training_jobs_for_hyper_parameter_tuning_job} \tab Gets a list of TrainingJobSummary objects that describe the training jobs that a hyperparameter tuning job launched \cr
\link[=sagemaker_list_transform_jobs]{list_transform_jobs} \tab Lists transform jobs \cr
\link[=sagemaker_list_trial_components]{list_trial_components} \tab Lists the trial components in your account \cr
\link[=sagemaker_list_trials]{list_trials} \tab Lists the trials in your account \cr
\link[=sagemaker_list_user_profiles]{list_user_profiles} \tab Lists user profiles \cr
\link[=sagemaker_list_workteams]{list_workteams} \tab Gets a list of work teams that you have defined in a region \cr
\link[=sagemaker_render_ui_template]{render_ui_template} \tab Renders the UI template so that you can preview the worker's experience \cr
\link[=sagemaker_search]{search} \tab Finds Amazon SageMaker resources that match a search query \cr
\link[=sagemaker_start_monitoring_schedule]{start_monitoring_schedule} \tab Starts a previously stopped monitoring schedule \cr
\link[=sagemaker_start_notebook_instance]{start_notebook_instance} \tab Launches an ML compute instance with the latest version of the libraries and attaches your ML storage volume \cr
\link[=sagemaker_stop_auto_ml_job]{stop_auto_ml_job} \tab A method for forcing the termination of a running job \cr
\link[=sagemaker_stop_compilation_job]{stop_compilation_job} \tab Stops a model compilation job \cr
\link[=sagemaker_stop_hyper_parameter_tuning_job]{stop_hyper_parameter_tuning_job} \tab Stops a running hyperparameter tuning job and all running training jobs that the tuning job launched \cr
\link[=sagemaker_stop_labeling_job]{stop_labeling_job} \tab Stops a running labeling job \cr
\link[=sagemaker_stop_monitoring_schedule]{stop_monitoring_schedule} \tab Stops a previously started monitoring schedule \cr
\link[=sagemaker_stop_notebook_instance]{stop_notebook_instance} \tab Terminates the ML compute instance \cr
\link[=sagemaker_stop_processing_job]{stop_processing_job} \tab Stops a processing job \cr
\link[=sagemaker_stop_training_job]{stop_training_job} \tab Stops a training job \cr
\link[=sagemaker_stop_transform_job]{stop_transform_job} \tab Stops a transform job \cr
\link[=sagemaker_update_code_repository]{update_code_repository} \tab Updates the specified Git repository with the specified values \cr
\link[=sagemaker_update_domain]{update_domain} \tab Updates the default settings for new user profiles in the domain \cr
\link[=sagemaker_update_endpoint]{update_endpoint} \tab Deploys the new EndpointConfig specified in the request, switches to using newly created endpoint, and then deletes resources provisioned for the endpoint using the previous EndpointConfig (there is no availability loss)\cr
\link[=sagemaker_update_endpoint_weights_and_capacities]{update_endpoint_weights_and_capacities} \tab Updates variant weight of one or more variants associated with an existing endpoint, or capacity of one variant associated with an existing endpoint \cr
\link[=sagemaker_update_experiment]{update_experiment} \tab Adds, updates, or removes the description of an experiment \cr
\link[=sagemaker_update_monitoring_schedule]{update_monitoring_schedule} \tab Updates a previously created schedule \cr
\link[=sagemaker_update_notebook_instance]{update_notebook_instance} \tab Updates a notebook instance \cr
\link[=sagemaker_update_notebook_instance_lifecycle_config]{update_notebook_instance_lifecycle_config} \tab Updates a notebook instance lifecycle configuration created with the CreateNotebookInstanceLifecycleConfig API \cr
\link[=sagemaker_update_trial]{update_trial} \tab Updates the display name of a trial \cr
\link[=sagemaker_update_trial_component]{update_trial_component} \tab Updates one or more properties of a trial component \cr
\link[=sagemaker_update_user_profile]{update_user_profile} \tab Updates a user profile \cr
\link[=sagemaker_update_workforce]{update_workforce} \tab Restricts access to tasks assigned to workers in the specified workforce to those within specific ranges of IP addresses \cr
\link[=sagemaker_update_workteam]{update_workteam} \tab Updates an existing work team with new member definitions or description
}
}

\examples{
\dontrun{
svc <- sagemaker()
svc$add_tags(
  Foo = 123
)
}

}
