% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paws.R
\name{organizations}
\alias{organizations}
\title{AWS Organizations}
\usage{
organizations()
}
\description{
AWS Organizations API Reference

AWS Organizations is a web service that enables you to consolidate your
multiple AWS accounts into an \emph{organization} and centrally manage your
accounts and their resources.

This guide provides descriptions of the Organizations API. For more
information about using this service, see the \href{https://docs.aws.amazon.com/organizations/latest/userguide/orgs_introduction.html}{AWS Organizations User Guide}.

\strong{API Version}

This version of the Organizations API Reference documents the
Organizations API version 2016-11-28.

As an alternative to using the API directly, you can use one of the AWS
SDKs, which consist of libraries and sample code for various programming
languages and platforms (Java, Ruby, .NET, iOS, Android, and more). The
SDKs provide a convenient way to create programmatic access to AWS
Organizations. For example, the SDKs take care of cryptographically
signing requests, managing errors, and retrying requests automatically.
For more information about the AWS SDKs, including how to download and
install them, see \href{http://aws.amazon.com/tools/}{Tools for Amazon Web Services}.

We recommend that you use the AWS SDKs to make programmatic API calls to
Organizations. However, you also can use the Organizations Query API to
make direct calls to the Organizations web service. To learn more about
the Organizations Query API, see \href{https://docs.aws.amazon.com/organizations/latest/userguide/orgs_query-requests.html}{Making Query Requests}
in the \emph{AWS Organizations User Guide}. Organizations supports GET and
POST requests for all actions. That is, the API does not require you to
use GET for some actions and POST for others. However, GET requests are
subject to the limitation size of a URL. Therefore, for operations that
require larger sizes, use a POST request.

\strong{Signing Requests}

When you send HTTP requests to AWS, you must sign the requests so that
AWS can identify who sent them. You sign requests with your AWS access
key, which consists of an access key ID and a secret access key. We
strongly recommend that you do not create an access key for your root
account. Anyone who has the access key for your root account has
unrestricted access to all the resources in your account. Instead,
create an access key for an IAM user account that has administrative
privileges. As another option, use AWS Security Token Service to
generate temporary security credentials, and use those credentials to
sign requests.

To sign requests, we recommend that you use \href{https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html}{Signature Version 4}.
If you have an existing application that uses Signature Version 2, you
do not have to update it to use Signature Version 4. However, some
operations now require Signature Version 4. The documentation for
operations that require version 4 indicate this requirement.

When you use the AWS Command Line Interface (AWS CLI) or one of the AWS
SDKs to make requests to AWS, these tools automatically sign the
requests for you with the access key that you specify when you configure
the tools.

In this release, each organization can have only one root. In a future
release, a single organization will support multiple roots.

\strong{Support and Feedback for AWS Organizations}

We welcome your feedback. Send your comments to
\href{mailto:feedback-awsorganizations@amazon.com}{feedback-awsorganizations@amazon.com} or post your feedback and
questions in the \href{http://forums.aws.amazon.com/forum.jspa?forumID=219}{AWS Organizations support forum}. For more
information about the AWS support forums, see \href{http://forums.aws.amazon.com/help.jspa}{Forums Help}.

\strong{Endpoint to Call When Using the CLI or the AWS API}

For the current release of Organizations, you must specify the
\code{us-east-1} region for all AWS API and CLI calls. You can do this in the
CLI by using these parameters and commands:
\itemize{
\item Use the following parameter with each command to specify both the
endpoint and its region:

\code{--endpoint-url https://organizations.us-east-1.amazonaws.com}
\item Use the default endpoint, but configure your default region with
this command:

\code{aws configure set default.region us-east-1}
\item Use the following parameter with each command to specify the
endpoint:

\code{--region us-east-1}
}

For the various SDKs used to call the APIs, see the documentation for
the SDK of interest to learn how to direct the requests to a specific
endpoint. For more information, see \href{https://docs.aws.amazon.com/general/latest/gr/rande.html#sts_region}{Regions and Endpoints}
in the \emph{AWS General Reference}.

\strong{How examples are presented}

The JSON returned by the AWS Organizations service as response to your
requests is returned as a single long string without line breaks or
formatting whitespace. Both line breaks and whitespace are included in
the examples in this guide to improve readability. When example input
parameters also would result in long strings that would extend beyond
the screen, we insert line breaks to enhance readability. You should
always submit the input as a single JSON text string.

\strong{Recording API Requests}

AWS Organizations supports AWS CloudTrail, a service that records AWS
API calls for your AWS account and delivers log files to an Amazon S3
bucket. By using information collected by AWS CloudTrail, you can
determine which requests were successfully made to Organizations, who
made the request, when it was made, and so on. For more about AWS
Organizations and its support for AWS CloudTrail, see \href{https://docs.aws.amazon.com/organizations/latest/userguide/orgs_monitoring.html#orgs_cloudtrail-integration}{Logging AWS Organizations Events with AWS CloudTrail}
in the \emph{AWS Organizations User Guide}. To learn more about CloudTrail,
including how to turn it on and find your log files, see the \href{https://docs.aws.amazon.com/awscloudtrail/latest/userguide/what_is_cloud_trail_top_level.html}{AWS CloudTrail User Guide}.
}
\section{Operations}{

\tabular{ll}{
\link[=organizations_accept_handshake]{accept_handshake} \tab Sends a response to the originator of a handshake agreeing to the action proposed by the handshake request \cr
\link[=organizations_attach_policy]{attach_policy} \tab Attaches a policy to a root, an organizational unit (OU), or an individual account \cr
\link[=organizations_cancel_handshake]{cancel_handshake} \tab Cancels a handshake \cr
\link[=organizations_create_account]{create_account} \tab Creates an AWS account that is automatically a member of the organization whose credentials made the request \cr
\link[=organizations_create_organization]{create_organization} \tab Creates an AWS organization \cr
\link[=organizations_create_organizational_unit]{create_organizational_unit} \tab Creates an organizational unit (OU) within a root or parent OU \cr
\link[=organizations_create_policy]{create_policy} \tab Creates a policy of a specified type that you can attach to a root, an organizational unit (OU), or an individual AWS account \cr
\link[=organizations_decline_handshake]{decline_handshake} \tab Declines a handshake request \cr
\link[=organizations_delete_organization]{delete_organization} \tab Deletes the organization \cr
\link[=organizations_delete_organizational_unit]{delete_organizational_unit} \tab Deletes an organizational unit (OU) from a root or another OU \cr
\link[=organizations_delete_policy]{delete_policy} \tab Deletes the specified policy from your organization \cr
\link[=organizations_describe_account]{describe_account} \tab Retrieves Organizations-related information about the specified account \cr
\link[=organizations_describe_create_account_status]{describe_create_account_status} \tab Retrieves the current status of an asynchronous request to create an account \cr
\link[=organizations_describe_handshake]{describe_handshake} \tab Retrieves information about a previously requested handshake \cr
\link[=organizations_describe_organization]{describe_organization} \tab Retrieves information about the organization that the user's account belongs to \cr
\link[=organizations_describe_organizational_unit]{describe_organizational_unit} \tab Retrieves information about an organizational unit (OU) \cr
\link[=organizations_describe_policy]{describe_policy} \tab Retrieves information about a policy \cr
\link[=organizations_detach_policy]{detach_policy} \tab Detaches a policy from a target root, organizational unit (OU), or account \cr
\link[=organizations_disable_aws_service_access]{disable_aws_service_access} \tab Disables the integration of an AWS service (the service that is specified by ServicePrincipal) with AWS Organizations \cr
\link[=organizations_disable_policy_type]{disable_policy_type} \tab Disables an organizational control policy type in a root \cr
\link[=organizations_enable_aws_service_access]{enable_aws_service_access} \tab Enables the integration of an AWS service (the service that is specified by ServicePrincipal) with AWS Organizations \cr
\link[=organizations_enable_all_features]{enable_all_features} \tab Enables all features in an organization \cr
\link[=organizations_enable_policy_type]{enable_policy_type} \tab Enables a policy type in a root \cr
\link[=organizations_invite_account_to_organization]{invite_account_to_organization} \tab Sends an invitation to another account to join your organization as a member account \cr
\link[=organizations_leave_organization]{leave_organization} \tab Removes a member account from its parent organization \cr
\link[=organizations_list_aws_service_access_for_organization]{list_aws_service_access_for_organization} \tab Returns a list of the AWS services that you enabled to integrate with your organization \cr
\link[=organizations_list_accounts]{list_accounts} \tab Lists all the accounts in the organization \cr
\link[=organizations_list_accounts_for_parent]{list_accounts_for_parent} \tab Lists the accounts in an organization that are contained by the specified target root or organizational unit (OU) \cr
\link[=organizations_list_children]{list_children} \tab Lists all of the organizational units (OUs) or accounts that are contained in the specified parent OU or root \cr
\link[=organizations_list_create_account_status]{list_create_account_status} \tab Lists the account creation requests that match the specified status that is currently being tracked for the organization \cr
\link[=organizations_list_handshakes_for_account]{list_handshakes_for_account} \tab Lists the current handshakes that are associated with the account of the requesting user \cr
\link[=organizations_list_handshakes_for_organization]{list_handshakes_for_organization} \tab Lists the handshakes that are associated with the organization that the requesting user is part of \cr
\link[=organizations_list_organizational_units_for_parent]{list_organizational_units_for_parent} \tab Lists the organizational units (OUs) in a parent organizational unit or root \cr
\link[=organizations_list_parents]{list_parents} \tab Lists the root or organizational units (OUs) that serve as the immediate parent of the specified child OU or account \cr
\link[=organizations_list_policies]{list_policies} \tab Retrieves the list of all policies in an organization of a specified type \cr
\link[=organizations_list_policies_for_target]{list_policies_for_target} \tab Lists the policies that are directly attached to the specified target root, organizational unit (OU), or account \cr
\link[=organizations_list_roots]{list_roots} \tab Lists the roots that are defined in the current organization \cr
\link[=organizations_list_targets_for_policy]{list_targets_for_policy} \tab Lists all the roots, organizaitonal units (OUs), and accounts to which the specified policy is attached \cr
\link[=organizations_move_account]{move_account} \tab Moves an account from its current source parent root or organizational unit (OU) to the specified destination parent root or OU\cr
\link[=organizations_remove_account_from_organization]{remove_account_from_organization} \tab Removes the specified account from the organization \cr
\link[=organizations_update_organizational_unit]{update_organizational_unit} \tab Renames the specified organizational unit (OU) \cr
\link[=organizations_update_policy]{update_policy} \tab Updates an existing policy with a new name, description, or content
}
}

\examples{
# Bill is the owner of an organization, and he invites Juan's account
# (222222222222) to join his organization. The following example shows
# Juan's account accepting the handshake and thus agreeing to the
# invitation.
\donttest{svc <- organizations()
svc$accept_handshake(
  HandshakeId = "h-examplehandshakeid111"
)}

}
