% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/storagegateway_operations.R
\name{storagegateway_update_nfs_file_share}
\alias{storagegateway_update_nfs_file_share}
\title{Updates a Network File System (NFS) file share}
\usage{
storagegateway_update_nfs_file_share(
  FileShareARN,
  EncryptionType = NULL,
  KMSEncrypted = NULL,
  KMSKey = NULL,
  NFSFileShareDefaults = NULL,
  DefaultStorageClass = NULL,
  ObjectACL = NULL,
  ClientList = NULL,
  Squash = NULL,
  ReadOnly = NULL,
  GuessMIMETypeEnabled = NULL,
  RequesterPays = NULL,
  FileShareName = NULL,
  CacheAttributes = NULL,
  NotificationPolicy = NULL,
  AuditDestinationARN = NULL
)
}
\arguments{
\item{FileShareARN}{[required] The Amazon Resource Name (ARN) of the file share to be updated.}

\item{EncryptionType}{A value that specifies the type of server-side encryption that the file
share will use for the data that it stores in Amazon S3.

We recommend using \code{EncryptionType} instead of \code{KMSEncrypted} to set the
file share encryption method. You do not need to provide values for both
parameters.

If values for both parameters exist in the same request, then the
specified encryption methods must not conflict. For example, if
\code{EncryptionType} is \code{SseS3}, then \code{KMSEncrypted} must be \code{false}. If
\code{EncryptionType} is \code{SseKms} or \code{DsseKms}, then \code{KMSEncrypted} must be
\code{true}.}

\item{KMSEncrypted}{Optional. Set to \code{true} to use Amazon S3 server-side encryption with
your own KMS key (SSE-KMS), or \code{false} to use a key managed by Amazon S3
(SSE-S3). To use dual-layer encryption (DSSE-KMS), set the
\code{EncryptionType} parameter instead.

We recommend using \code{EncryptionType} instead of \code{KMSEncrypted} to set the
file share encryption method. You do not need to provide values for both
parameters.

If values for both parameters exist in the same request, then the
specified encryption methods must not conflict. For example, if
\code{EncryptionType} is \code{SseS3}, then \code{KMSEncrypted} must be \code{false}. If
\code{EncryptionType} is \code{SseKms} or \code{DsseKms}, then \code{KMSEncrypted} must be
\code{true}.

Valid Values: \code{true} | \code{false}}

\item{KMSKey}{Optional. The Amazon Resource Name (ARN) of a symmetric customer master
key (CMK) used for Amazon S3 server-side encryption. Storage Gateway
does not support asymmetric CMKs. This value must be set if
\code{KMSEncrypted} is \code{true}, or if \code{EncryptionType} is \code{SseKms} or
\code{DsseKms}.}

\item{NFSFileShareDefaults}{The default values for the file share. Optional.}

\item{DefaultStorageClass}{The default storage class for objects put into an Amazon S3 bucket by
the S3 File Gateway. The default value is \code{S3_STANDARD}. Optional.

Valid Values: \code{S3_STANDARD} | \code{S3_INTELLIGENT_TIERING} |
\code{S3_STANDARD_IA} | \code{S3_ONEZONE_IA}}

\item{ObjectACL}{A value that sets the access control list (ACL) permission for objects
in the S3 bucket that a S3 File Gateway puts objects into. The default
value is \code{private}.}

\item{ClientList}{The list of clients that are allowed to access the S3 File Gateway. The
list must contain either valid IP addresses or valid CIDR blocks.}

\item{Squash}{The user mapped to anonymous user.

Valid values are the following:
\itemize{
\item \code{RootSquash}: Only root is mapped to anonymous user.
\item \code{NoSquash}: No one is mapped to anonymous user.
\item \code{AllSquash}: Everyone is mapped to anonymous user.
}}

\item{ReadOnly}{A value that sets the write status of a file share. Set this value to
\code{true} to set the write status to read-only, otherwise set to \code{false}.

Valid Values: \code{true} | \code{false}}

\item{GuessMIMETypeEnabled}{A value that enables guessing of the MIME type for uploaded objects
based on file extensions. Set this value to \code{true} to enable MIME type
guessing, otherwise set to \code{false}. The default value is \code{true}.

Valid Values: \code{true} | \code{false}}

\item{RequesterPays}{A value that sets who pays the cost of the request and the cost
associated with data download from the S3 bucket. If this value is set
to \code{true}, the requester pays the costs; otherwise, the S3 bucket owner
pays. However, the S3 bucket owner always pays the cost of storing data.

\code{RequesterPays} is a configuration for the S3 bucket that backs the file
share, so make sure that the configuration on the file share is the same
as the S3 bucket configuration.

Valid Values: \code{true} | \code{false}}

\item{FileShareName}{The name of the file share. Optional.

\code{FileShareName} must be set if an S3 prefix name is set in
\code{LocationARN}, or if an access point or access point alias is used.

A valid NFS file share name can only contain the following characters:
\code{a}-\code{z}, \code{A}-\code{Z}, \code{0}-\code{9}, \code{-}, \code{.}, and \verb{_}.}

\item{CacheAttributes}{Specifies refresh cache information for the file share.}

\item{NotificationPolicy}{The notification policy of the file share. \code{SettlingTimeInSeconds}
controls the number of seconds to wait after the last point in time a
client wrote to a file before generating an \code{ObjectUploaded}
notification. Because clients can make many small writes to files, it's
best to set this parameter for as long as possible to avoid generating
multiple notifications for the same file in a small time period.

\code{SettlingTimeInSeconds} has no effect on the timing of the object
uploading to Amazon S3, only the timing of the notification.

This setting is not meant to specify an exact time at which the
notification will be sent. In some cases, the gateway might require more
than the specified delay time to generate and send notifications.

The following example sets \code{NotificationPolicy} on with
\code{SettlingTimeInSeconds} set to 60.

\verb{\{\\"Upload\\": \{\\"SettlingTimeInSeconds\\": 60\}\}}

The following example sets \code{NotificationPolicy} off.

\code{{}}}

\item{AuditDestinationARN}{The Amazon Resource Name (ARN) of the storage used for audit logs.}
}
\description{
Updates a Network File System (NFS) file share. This operation is only supported in S3 File Gateways.

See \url{https://www.paws-r-sdk.com/docs/storagegateway_update_nfs_file_share/} for full documentation.
}
\keyword{internal}
