% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_operations.R
\name{s3_write_get_object_response}
\alias{s3_write_get_object_response}
\title{This operation is not supported for directory buckets}
\usage{
s3_write_get_object_response(
  RequestRoute,
  RequestToken,
  Body = NULL,
  StatusCode = NULL,
  ErrorCode = NULL,
  ErrorMessage = NULL,
  AcceptRanges = NULL,
  CacheControl = NULL,
  ContentDisposition = NULL,
  ContentEncoding = NULL,
  ContentLanguage = NULL,
  ContentLength = NULL,
  ContentRange = NULL,
  ContentType = NULL,
  ChecksumCRC32 = NULL,
  ChecksumCRC32C = NULL,
  ChecksumCRC64NVME = NULL,
  ChecksumSHA1 = NULL,
  ChecksumSHA256 = NULL,
  DeleteMarker = NULL,
  ETag = NULL,
  Expires = NULL,
  Expiration = NULL,
  LastModified = NULL,
  MissingMeta = NULL,
  Metadata = NULL,
  ObjectLockMode = NULL,
  ObjectLockLegalHoldStatus = NULL,
  ObjectLockRetainUntilDate = NULL,
  PartsCount = NULL,
  ReplicationStatus = NULL,
  RequestCharged = NULL,
  Restore = NULL,
  ServerSideEncryption = NULL,
  SSECustomerAlgorithm = NULL,
  SSEKMSKeyId = NULL,
  SSECustomerKeyMD5 = NULL,
  StorageClass = NULL,
  TagCount = NULL,
  VersionId = NULL,
  BucketKeyEnabled = NULL
)
}
\arguments{
\item{RequestRoute}{[required] Route prefix to the HTTP URL generated.}

\item{RequestToken}{[required] A single use encrypted token that maps
\code{\link[=s3_write_get_object_response]{write_get_object_response}} to the end
user \code{\link[=s3_get_object]{get_object}} request.}

\item{Body}{The object data.}

\item{StatusCode}{The integer status code for an HTTP response of a corresponding
\code{\link[=s3_get_object]{get_object}} request. The following is a list of status
codes.
\itemize{
\item \code{200 - OK}
\item \verb{206 - Partial Content}
\item \verb{304 - Not Modified}
\item \verb{400 - Bad Request}
\item \code{401 - Unauthorized}
\item \code{403 - Forbidden}
\item \verb{404 - Not Found}
\item \verb{405 - Method Not Allowed}
\item \code{409 - Conflict}
\item \verb{411 - Length Required}
\item \verb{412 - Precondition Failed}
\item \verb{416 - Range Not Satisfiable}
\item \verb{500 - Internal Server Error}
\item \verb{503 - Service Unavailable}
}}

\item{ErrorCode}{A string that uniquely identifies an error condition. Returned in the
\<Code\> tag of the error XML response for a corresponding
\code{\link[=s3_get_object]{get_object}} call. Cannot be used with a successful
\code{StatusCode} header or when the transformed object is provided in the
body. All error codes from S3 are sentence-cased. The regular expression
(regex) value is \code{"^[A-Z][a-zA-Z]+$"}.}

\item{ErrorMessage}{Contains a generic description of the error condition. Returned in the
\<Message\> tag of the error XML response for a corresponding
\code{\link[=s3_get_object]{get_object}} call. Cannot be used with a successful
\code{StatusCode} header or when the transformed object is provided in body.}

\item{AcceptRanges}{Indicates that a range of bytes was specified.}

\item{CacheControl}{Specifies caching behavior along the request/reply chain.}

\item{ContentDisposition}{Specifies presentational information for the object.}

\item{ContentEncoding}{Specifies what content encodings have been applied to the object and
thus what decoding mechanisms must be applied to obtain the media-type
referenced by the Content-Type header field.}

\item{ContentLanguage}{The language the content is in.}

\item{ContentLength}{The size of the content body in bytes.}

\item{ContentRange}{The portion of the object returned in the response.}

\item{ContentType}{A standard MIME type describing the format of the object data.}

\item{ChecksumCRC32}{This header can be used as a data integrity check to verify that the
data received is the same data that was originally sent. This specifies
the Base64 encoded, 32-bit \code{CRC-32} checksum of the object returned by
the Object Lambda function. This may not match the checksum for the
object stored in Amazon S3. Amazon S3 will perform validation of the
checksum values only when the original \code{\link[=s3_get_object]{get_object}}
request required checksum validation. For more information about
checksums, see \href{https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html}{Checking object integrity}
in the \emph{Amazon S3 User Guide}.

Only one checksum header can be specified at a time. If you supply
multiple checksum headers, this request will fail.}

\item{ChecksumCRC32C}{This header can be used as a data integrity check to verify that the
data received is the same data that was originally sent. This specifies
the Base64 encoded, 32-bit \verb{CRC-32C} checksum of the object returned by
the Object Lambda function. This may not match the checksum for the
object stored in Amazon S3. Amazon S3 will perform validation of the
checksum values only when the original \code{\link[=s3_get_object]{get_object}}
request required checksum validation. For more information about
checksums, see \href{https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html}{Checking object integrity}
in the \emph{Amazon S3 User Guide}.

Only one checksum header can be specified at a time. If you supply
multiple checksum headers, this request will fail.}

\item{ChecksumCRC64NVME}{This header can be used as a data integrity check to verify that the
data received is the same data that was originally sent. This header
specifies the Base64 encoded, 64-bit \verb{CRC-64NVME} checksum of the part.
For more information, see \href{https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html}{Checking object integrity}
in the \emph{Amazon S3 User Guide}.}

\item{ChecksumSHA1}{This header can be used as a data integrity check to verify that the
data received is the same data that was originally sent. This specifies
the Base64 encoded, 160-bit \code{SHA-1} digest of the object returned by the
Object Lambda function. This may not match the checksum for the object
stored in Amazon S3. Amazon S3 will perform validation of the checksum
values only when the original \code{\link[=s3_get_object]{get_object}} request
required checksum validation. For more information about checksums, see
\href{https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html}{Checking object integrity}
in the \emph{Amazon S3 User Guide}.

Only one checksum header can be specified at a time. If you supply
multiple checksum headers, this request will fail.}

\item{ChecksumSHA256}{This header can be used as a data integrity check to verify that the
data received is the same data that was originally sent. This specifies
the Base64 encoded, 256-bit \code{SHA-256} digest of the object returned by
the Object Lambda function. This may not match the checksum for the
object stored in Amazon S3. Amazon S3 will perform validation of the
checksum values only when the original \code{\link[=s3_get_object]{get_object}}
request required checksum validation. For more information about
checksums, see \href{https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html}{Checking object integrity}
in the \emph{Amazon S3 User Guide}.

Only one checksum header can be specified at a time. If you supply
multiple checksum headers, this request will fail.}

\item{DeleteMarker}{Specifies whether an object stored in Amazon S3 is (\code{true}) or is not
(\code{false}) a delete marker.}

\item{ETag}{An opaque identifier assigned by a web server to a specific version of a
resource found at a URL.}

\item{Expires}{The date and time at which the object is no longer cacheable.}

\item{Expiration}{If the object expiration is configured (see PUT Bucket lifecycle), the
response includes this header. It includes the \code{expiry-date} and
\code{rule-id} key-value pairs that provide the object expiration
information. The value of the \code{rule-id} is URL-encoded.}

\item{LastModified}{The date and time that the object was last modified.}

\item{MissingMeta}{Set to the number of metadata entries not returned in \code{x-amz-meta}
headers. This can happen if you create metadata using an API like SOAP
that supports more flexible metadata than the REST API. For example,
using SOAP, you can create metadata whose values are not legal HTTP
headers.}

\item{Metadata}{A map of metadata to store with the object in S3.}

\item{ObjectLockMode}{Indicates whether an object stored in Amazon S3 has Object Lock enabled.
For more information about S3 Object Lock, see \href{https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-lock.html}{Object Lock}.}

\item{ObjectLockLegalHoldStatus}{Indicates whether an object stored in Amazon S3 has an active legal
hold.}

\item{ObjectLockRetainUntilDate}{The date and time when Object Lock is configured to expire.}

\item{PartsCount}{The count of parts this object has.}

\item{ReplicationStatus}{Indicates if request involves bucket that is either a source or
destination in a Replication rule. For more information about S3
Replication, see
\href{https://docs.aws.amazon.com/AmazonS3/latest/userguide/replication.html}{Replication}.}

\item{RequestCharged}{}

\item{Restore}{Provides information about object restoration operation and expiration
time of the restored object copy.}

\item{ServerSideEncryption}{The server-side encryption algorithm used when storing requested object
in Amazon S3 (for example, AES256, \code{aws:kms}).}

\item{SSECustomerAlgorithm}{Encryption algorithm used if server-side encryption with a
customer-provided encryption key was specified for object stored in
Amazon S3.}

\item{SSEKMSKeyId}{If present, specifies the ID (Key ID, Key ARN, or Key Alias) of the
Amazon Web Services Key Management Service (Amazon Web Services KMS)
symmetric encryption customer managed key that was used for stored in
Amazon S3 object.}

\item{SSECustomerKeyMD5}{128-bit MD5 digest of customer-provided encryption key used in Amazon S3
to encrypt data stored in S3. For more information, see \href{https://docs.aws.amazon.com/AmazonS3/latest/userguide/ServerSideEncryptionCustomerKeys.html}{Protecting data using server-side encryption with customer-provided encryption keys (SSE-C)}.}

\item{StorageClass}{Provides storage class information of the object. Amazon S3 returns this
header for all objects except for S3 Standard storage class objects.

For more information, see \href{https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage-class-intro.html}{Storage Classes}.}

\item{TagCount}{The number of tags, if any, on the object.}

\item{VersionId}{An ID used to reference a specific version of the object.}

\item{BucketKeyEnabled}{Indicates whether the object stored in Amazon S3 uses an S3 bucket key
for server-side encryption with Amazon Web Services KMS (SSE-KMS).}
}
\description{
This operation is not supported for directory buckets.

See \url{https://www.paws-r-sdk.com/docs/s3_write_get_object_response/} for full documentation.
}
\keyword{internal}
