% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_operations.R
\name{s3_create_session}
\alias{s3_create_session}
\title{Creates a session that establishes temporary security credentials to
support fast authentication and authorization for the Zonal endpoint
APIs on directory buckets}
\usage{
s3_create_session(SessionMode = NULL, Bucket)
}
\arguments{
\item{SessionMode}{Specifies the mode of the session that will be created, either
\code{ReadWrite} or \code{ReadOnly}. By default, a \code{ReadWrite} session is created.
A \code{ReadWrite} session is capable of executing all the Zonal endpoint
APIs on a directory bucket. A \code{ReadOnly} session is constrained to
execute the following Zonal endpoint APIs:
\code{\link[=s3_get_object]{get_object}}, \code{\link[=s3_head_object]{head_object}},
\code{\link[=s3_list_objects_v2]{list_objects_v2}},
\code{\link[=s3_get_object_attributes]{get_object_attributes}},
\code{\link[=s3_list_parts]{list_parts}}, and
\code{\link[=s3_list_multipart_uploads]{list_multipart_uploads}}.}

\item{Bucket}{[required] The name of the bucket that you create a session for.}
}
\description{
Creates a session that establishes temporary security credentials to support fast authentication and authorization for the Zonal endpoint APIs on directory buckets. For more information about Zonal endpoint APIs that include the Availability Zone in the request endpoint, see \href{https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-express-APIs.html}{S3 Express One Zone APIs} in the \emph{Amazon S3 User Guide}.

See \url{https://www.paws-r-sdk.com/docs/s3_create_session/} for full documentation.
}
\keyword{internal}
