% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_operations.R
\name{s3_delete_bucket_policy}
\alias{s3_delete_bucket_policy}
\title{This implementation of the DELETE action uses the policy subresource to
delete the policy of a specified bucket}
\usage{
s3_delete_bucket_policy(Bucket, ExpectedBucketOwner = NULL)
}
\arguments{
\item{Bucket}{[required] The bucket name.}

\item{ExpectedBucketOwner}{The account ID of the expected bucket owner. If the bucket is owned by a
different account, the request fails with the HTTP status code
\verb{403 Forbidden} (access denied).}
}
\description{
This implementation of the DELETE action uses the policy subresource to delete the policy of a specified bucket. If you are using an identity other than the root user of the Amazon Web Services account that owns the bucket, the calling identity must have the \code{\link[=s3_delete_bucket_policy]{delete_bucket_policy}} permissions on the specified bucket and belong to the bucket owner's account to use this operation.

See \url{https://www.paws-r-sdk.com/docs/s3_delete_bucket_policy/} for full documentation.
}
\keyword{internal}
