% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backup_operations.R
\name{backup_start_restore_job}
\alias{backup_start_restore_job}
\title{Recovers the saved resource identified by an Amazon Resource Name (ARN)}
\usage{
backup_start_restore_job(
  RecoveryPointArn,
  Metadata,
  IamRoleArn = NULL,
  IdempotencyToken = NULL,
  ResourceType = NULL,
  CopySourceTagsToRestoredResource = NULL
)
}
\arguments{
\item{RecoveryPointArn}{[required] An ARN that uniquely identifies a recovery point; for example,
\verb{arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45}.}

\item{Metadata}{[required] A set of metadata key-value pairs. Contains information, such as a
resource name, required to restore a recovery point.

You can get configuration metadata about a resource at the time it was
backed up by calling
\code{\link[=backup_get_recovery_point_restore_metadata]{get_recovery_point_restore_metadata}}.
However, values in addition to those provided by
\code{\link[=backup_get_recovery_point_restore_metadata]{get_recovery_point_restore_metadata}}
might be required to restore a resource. For example, you might need to
provide a new resource name if the original already exists.

You need to specify specific metadata to restore an Amazon Elastic File
System (Amazon EFS) instance:
\itemize{
\item \code{file-system-id}: The ID of the Amazon EFS file system that is
backed up by Backup. Returned in
\code{\link[=backup_get_recovery_point_restore_metadata]{get_recovery_point_restore_metadata}}.
\item \code{Encrypted}: A Boolean value that, if true, specifies that the file
system is encrypted. If \code{KmsKeyId} is specified, \code{Encrypted} must be
set to \code{true}.
\item \code{KmsKeyId}: Specifies the Amazon Web Services KMS key that is used
to encrypt the restored file system. You can specify a key from
another Amazon Web Services account provided that key it is properly
shared with your account via Amazon Web Services KMS.
\item \code{PerformanceMode}: Specifies the throughput mode of the file system.
\item \code{CreationToken}: A user-supplied value that ensures the uniqueness
(idempotency) of the request.
\item \code{newFileSystem}: A Boolean value that, if true, specifies that the
recovery point is restored to a new Amazon EFS file system.
\item \code{ItemsToRestore}: An array of one to five strings where each string
is a file path. Use \code{ItemsToRestore} to restore specific files or
directories rather than the entire file system. This parameter is
optional. For example, \verb{"itemsToRestore":"[\\"/my.test\\"]"}.
}}

\item{IamRoleArn}{The Amazon Resource Name (ARN) of the IAM role that Backup uses to
create the target resource; for example:
\verb{arn:aws:iam::123456789012:role/S3Access}.}

\item{IdempotencyToken}{A customer-chosen string that you can use to distinguish between
otherwise identical calls to
\code{\link[=backup_start_restore_job]{start_restore_job}}. Retrying a successful
request with the same idempotency token results in a success message
with no action taken.}

\item{ResourceType}{Starts a job to restore a recovery point for one of the following
resources:
\itemize{
\item \code{Aurora} for Amazon Aurora
\item \code{DocumentDB} for Amazon DocumentDB (with MongoDB compatibility)
\item \code{CloudFormation} for CloudFormation
\item \code{DynamoDB} for Amazon DynamoDB
\item \code{EBS} for Amazon Elastic Block Store
\item \code{EC2} for Amazon Elastic Compute Cloud
\item \code{EFS} for Amazon Elastic File System
\item \code{FSx} for Amazon FSx
\item \code{Neptune} for Amazon Neptune
\item \code{RDS} for Amazon Relational Database Service
\item \code{Redshift} for Amazon Redshift
\item \verb{Storage Gateway} for Storage Gateway
\item \code{S3} for Amazon S3
\item \code{Timestream} for Amazon Timestream
\item \code{VirtualMachine} for virtual machines
}}

\item{CopySourceTagsToRestoredResource}{This is an optional parameter. If this equals \code{True}, tags included in
the backup will be copied to the restored resource.

This can only be applied to backups created through Backup.}
}
\description{
Recovers the saved resource identified by an Amazon Resource Name (ARN).

See \url{https://www.paws-r-sdk.com/docs/backup_start_restore_job/} for full documentation.
}
\keyword{internal}
