% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/storagegateway_operations.R
\name{storagegateway_activate_gateway}
\alias{storagegateway_activate_gateway}
\title{Activates the gateway you previously deployed on your host}
\usage{
storagegateway_activate_gateway(
  ActivationKey,
  GatewayName,
  GatewayTimezone,
  GatewayRegion,
  GatewayType = NULL,
  TapeDriveType = NULL,
  MediumChangerType = NULL,
  Tags = NULL
)
}
\arguments{
\item{ActivationKey}{[required] Your gateway activation key. You can obtain the activation key by
sending an HTTP GET request with redirects enabled to the gateway IP
address (port 80). The redirect URL returned in the response provides
you the activation key for your gateway in the query string parameter
\code{activationKey}. It may also include other activation-related
parameters, however, these are merely defaults -- the arguments you pass
to the \code{\link[=storagegateway_activate_gateway]{activate_gateway}} API call
determine the actual configuration of your gateway.

For more information, see \href{https://docs.aws.amazon.com/storagegateway/index.html}{Getting activation key} in the
\emph{Storage Gateway User Guide}.}

\item{GatewayName}{[required] The name you configured for your gateway.}

\item{GatewayTimezone}{[required] A value that indicates the time zone you want to set for the gateway.
The time zone is of the format "GMT-hr:mm" or "GMT+hr:mm". For example,
GMT-4:00 indicates the time is 4 hours behind GMT. GMT+2:00 indicates
the time is 2 hours ahead of GMT. The time zone is used, for example,
for scheduling snapshots and your gateway's maintenance schedule.}

\item{GatewayRegion}{[required] A value that indicates the Amazon Web Services Region where you want to
store your data. The gateway Amazon Web Services Region specified must
be the same Amazon Web Services Region as the Amazon Web Services Region
in your \code{Host} header in the request. For more information about
available Amazon Web Services Regions and endpoints for Storage Gateway,
see \href{https://docs.aws.amazon.com/general/latest/gr/sg.html}{Storage Gateway endpoints and quotas} in the
\emph{Amazon Web Services General Reference}.

Valid Values: See \href{https://docs.aws.amazon.com/general/latest/gr/sg.html}{Storage Gateway endpoints and quotas} in the
\emph{Amazon Web Services General Reference}.}

\item{GatewayType}{A value that defines the type of gateway to activate. The type specified
is critical to all later functions of the gateway and cannot be changed
after activation. The default value is \code{CACHED}.

Valid Values: \code{STORED} | \code{CACHED} | \code{VTL} | \code{VTL_SNOW} | \code{FILE_S3} |
\code{FILE_FSX_SMB}}

\item{TapeDriveType}{The value that indicates the type of tape drive to use for tape gateway.
This field is optional.

Valid Values: \code{IBM-ULT3580-TD5}}

\item{MediumChangerType}{The value that indicates the type of medium changer to use for tape
gateway. This field is optional.

Valid Values: \code{STK-L700} | \code{AWS-Gateway-VTL} | \verb{IBM-03584L32-0402}}

\item{Tags}{A list of up to 50 tags that you can assign to the gateway. Each tag is
a key-value pair.

Valid characters for key and value are letters, spaces, and numbers that
can be represented in UTF-8 format, and the following special
characters: + - = . _ : / @. The maximum length of a tag's key is 128
characters, and the maximum length for a tag's value is 256 characters.}
}
\description{
Activates the gateway you previously deployed on your host. In the activation process, you specify information such as the Amazon Web Services Region that you want to use for storing snapshots or tapes, the time zone for scheduled snapshots the gateway snapshot schedule window, an activation key, and a name for your gateway. The activation process also associates your gateway with your account. For more information, see \code{\link[=storagegateway_update_gateway_information]{update_gateway_information}}.

See \url{https://paws-r.github.io/docs/storagegateway/activate_gateway.html} for full documentation.
}
\keyword{internal}
