% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3control_operations.R
\name{s3control_create_multi_region_access_point}
\alias{s3control_create_multi_region_access_point}
\title{Creates a Multi-Region Access Point and associates it with the specified
buckets}
\usage{
s3control_create_multi_region_access_point(AccountId, ClientToken, Details)
}
\arguments{
\item{AccountId}{[required] The Amazon Web Services account ID for the owner of the Multi-Region
Access Point. The owner of the Multi-Region Access Point also must own
the underlying buckets.}

\item{ClientToken}{[required] An idempotency token used to identify the request and guarantee that
requests are unique.}

\item{Details}{[required] A container element containing details about the Multi-Region Access
Point.}
}
\description{
Creates a Multi-Region Access Point and associates it with the specified buckets. For more information about creating Multi-Region Access Points, see \href{https://docs.aws.amazon.com/AmazonS3/latest/userguide/CreatingMultiRegionAccessPoints.html}{Creating Multi-Region Access Points} in the \emph{Amazon S3 User Guide}.

See \url{https://paws-r.github.io/docs/s3control/create_multi_region_access_point.html} for full documentation.
}
\keyword{internal}
