% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_operations.R
\name{s3_upload_part_copy}
\alias{s3_upload_part_copy}
\title{Uploads a part by copying data from an existing object as data source}
\usage{
s3_upload_part_copy(
  Bucket,
  CopySource,
  CopySourceIfMatch = NULL,
  CopySourceIfModifiedSince = NULL,
  CopySourceIfNoneMatch = NULL,
  CopySourceIfUnmodifiedSince = NULL,
  CopySourceRange = NULL,
  Key,
  PartNumber,
  UploadId,
  SSECustomerAlgorithm = NULL,
  SSECustomerKey = NULL,
  SSECustomerKeyMD5 = NULL,
  CopySourceSSECustomerAlgorithm = NULL,
  CopySourceSSECustomerKey = NULL,
  CopySourceSSECustomerKeyMD5 = NULL,
  RequestPayer = NULL,
  ExpectedBucketOwner = NULL,
  ExpectedSourceBucketOwner = NULL
)
}
\arguments{
\item{Bucket}{[required] The bucket name.

When using this action with an access point, you must direct requests to
the access point hostname. The access point hostname takes the form
\emph{AccessPointName}-\emph{AccountId}.s3-accesspoint.\emph{Region}.amazonaws.com.
When using this action with an access point through the Amazon Web
Services SDKs, you provide the access point ARN in place of the bucket
name. For more information about access point ARNs, see \href{https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html}{Using access points}
in the \emph{Amazon S3 User Guide}.

When using this action with Amazon S3 on Outposts, you must direct
requests to the S3 on Outposts hostname. The S3 on Outposts hostname
takes the form
\code{ AccessPointName-AccountId.outpostID.s3-outposts.Region.amazonaws.com}.
When using this action with S3 on Outposts through the Amazon Web
Services SDKs, you provide the Outposts bucket ARN in place of the
bucket name. For more information about S3 on Outposts ARNs, see \href{https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html}{Using Amazon S3 on Outposts}
in the \emph{Amazon S3 User Guide}.}

\item{CopySource}{[required] Specifies the source object for the copy operation. You specify the
value in one of two formats, depending on whether you want to access the
source object through an \href{https://docs.aws.amazon.com/AmazonS3/latest/userguide/access-points.html}{access point}:
\itemize{
\item For objects not accessed through an access point, specify the name
of the source bucket and key of the source object, separated by a
slash (/). For example, to copy the object \code{reports/january.pdf}
from the bucket \code{awsexamplebucket}, use
\code{awsexamplebucket/reports/january.pdf}. The value must be
URL-encoded.
\item For objects accessed through access points, specify the Amazon
Resource Name (ARN) of the object as accessed through the access
point, in the format
\verb{arn:aws:s3:<Region>:<account-id>:accesspoint/<access-point-name>/object/<key>}.
For example, to copy the object \code{reports/january.pdf} through access
point \code{my-access-point} owned by account \code{123456789012} in Region
\code{us-west-2}, use the URL encoding of
\code{arn:aws:s3:us-west-2:123456789012:accesspoint/my-access-point/object/reports/january.pdf}.
The value must be URL encoded.

Amazon S3 supports copy operations using access points only when the
source and destination buckets are in the same Amazon Web Services
Region.

Alternatively, for objects accessed through Amazon S3 on Outposts,
specify the ARN of the object as accessed in the format
\verb{arn:aws:s3-outposts:<Region>:<account-id>:outpost/<outpost-id>/object/<key>}.
For example, to copy the object \code{reports/january.pdf} through
outpost \code{my-outpost} owned by account \code{123456789012} in Region
\code{us-west-2}, use the URL encoding of
\code{arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/object/reports/january.pdf}.
The value must be URL-encoded.
}

To copy a specific version of an object, append
\verb{?versionId=<version-id>} to the value (for example,
\code{awsexamplebucket/reports/january.pdf?versionId=QUpfdndhfd8438MNFDN93jdnJFkdmqnh893}).
If you don't specify a version ID, Amazon S3 copies the latest version
of the source object.}

\item{CopySourceIfMatch}{Copies the object if its entity tag (ETag) matches the specified tag.}

\item{CopySourceIfModifiedSince}{Copies the object if it has been modified since the specified time.}

\item{CopySourceIfNoneMatch}{Copies the object if its entity tag (ETag) is different than the
specified ETag.}

\item{CopySourceIfUnmodifiedSince}{Copies the object if it hasn't been modified since the specified time.}

\item{CopySourceRange}{The range of bytes to copy from the source object. The range value must
use the form bytes=first-last, where the first and last are the
zero-based byte offsets to copy. For example, bytes=0-9 indicates that
you want to copy the first 10 bytes of the source. You can copy a range
only if the source object is greater than 5 MB.}

\item{Key}{[required] Object key for which the multipart upload was initiated.}

\item{PartNumber}{[required] Part number of part being copied. This is a positive integer between 1
and 10,000.}

\item{UploadId}{[required] Upload ID identifying the multipart upload whose part is being copied.}

\item{SSECustomerAlgorithm}{Specifies the algorithm to use to when encrypting the object (for
example, AES256).}

\item{SSECustomerKey}{Specifies the customer-provided encryption key for Amazon S3 to use in
encrypting data. This value is used to store the object and then it is
discarded; Amazon S3 does not store the encryption key. The key must be
appropriate for use with the algorithm specified in the
\code{x-amz-server-side-encryption-customer-algorithm} header. This must be
the same encryption key specified in the initiate multipart upload
request.}

\item{SSECustomerKeyMD5}{Specifies the 128-bit MD5 digest of the encryption key according to RFC
1321. Amazon S3 uses this header for a message integrity check to ensure
that the encryption key was transmitted without error.}

\item{CopySourceSSECustomerAlgorithm}{Specifies the algorithm to use when decrypting the source object (for
example, AES256).}

\item{CopySourceSSECustomerKey}{Specifies the customer-provided encryption key for Amazon S3 to use to
decrypt the source object. The encryption key provided in this header
must be one that was used when the source object was created.}

\item{CopySourceSSECustomerKeyMD5}{Specifies the 128-bit MD5 digest of the encryption key according to RFC
1321. Amazon S3 uses this header for a message integrity check to ensure
that the encryption key was transmitted without error.}

\item{RequestPayer}{}

\item{ExpectedBucketOwner}{The account ID of the expected destination bucket owner. If the
destination bucket is owned by a different account, the request fails
with the HTTP status code \verb{403 Forbidden} (access denied).}

\item{ExpectedSourceBucketOwner}{The account ID of the expected source bucket owner. If the source bucket
is owned by a different account, the request fails with the HTTP status
code \verb{403 Forbidden} (access denied).}
}
\description{
Uploads a part by copying data from an existing object as data source. You specify the data source by adding the request header \code{x-amz-copy-source} in your request and a byte range by adding the request header \code{x-amz-copy-source-range} in your request.

See \url{https://paws-r.github.io/docs/s3/upload_part_copy.html} for full documentation.
}
\keyword{internal}
