% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_operations.R
\name{s3_create_multipart_upload}
\alias{s3_create_multipart_upload}
\title{This action initiates a multipart upload and returns an upload ID}
\usage{
s3_create_multipart_upload(
  ACL = NULL,
  Bucket,
  CacheControl = NULL,
  ContentDisposition = NULL,
  ContentEncoding = NULL,
  ContentLanguage = NULL,
  ContentType = NULL,
  Expires = NULL,
  GrantFullControl = NULL,
  GrantRead = NULL,
  GrantReadACP = NULL,
  GrantWriteACP = NULL,
  Key,
  Metadata = NULL,
  ServerSideEncryption = NULL,
  StorageClass = NULL,
  WebsiteRedirectLocation = NULL,
  SSECustomerAlgorithm = NULL,
  SSECustomerKey = NULL,
  SSECustomerKeyMD5 = NULL,
  SSEKMSKeyId = NULL,
  SSEKMSEncryptionContext = NULL,
  BucketKeyEnabled = NULL,
  RequestPayer = NULL,
  Tagging = NULL,
  ObjectLockMode = NULL,
  ObjectLockRetainUntilDate = NULL,
  ObjectLockLegalHoldStatus = NULL,
  ExpectedBucketOwner = NULL,
  ChecksumAlgorithm = NULL
)
}
\arguments{
\item{ACL}{The canned ACL to apply to the object.

This action is not supported by Amazon S3 on Outposts.}

\item{Bucket}{[required] The name of the bucket to which to initiate the upload

When using this action with an access point, you must direct requests to
the access point hostname. The access point hostname takes the form
\emph{AccessPointName}-\emph{AccountId}.s3-accesspoint.\emph{Region}.amazonaws.com.
When using this action with an access point through the Amazon Web
Services SDKs, you provide the access point ARN in place of the bucket
name. For more information about access point ARNs, see \href{https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html}{Using access points}
in the \emph{Amazon S3 User Guide}.

When using this action with Amazon S3 on Outposts, you must direct
requests to the S3 on Outposts hostname. The S3 on Outposts hostname
takes the form
\code{ AccessPointName-AccountId.outpostID.s3-outposts.Region.amazonaws.com}.
When using this action with S3 on Outposts through the Amazon Web
Services SDKs, you provide the Outposts bucket ARN in place of the
bucket name. For more information about S3 on Outposts ARNs, see \href{https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html}{Using Amazon S3 on Outposts}
in the \emph{Amazon S3 User Guide}.}

\item{CacheControl}{Specifies caching behavior along the request/reply chain.}

\item{ContentDisposition}{Specifies presentational information for the object.}

\item{ContentEncoding}{Specifies what content encodings have been applied to the object and
thus what decoding mechanisms must be applied to obtain the media-type
referenced by the Content-Type header field.}

\item{ContentLanguage}{The language the content is in.}

\item{ContentType}{A standard MIME type describing the format of the object data.}

\item{Expires}{The date and time at which the object is no longer cacheable.}

\item{GrantFullControl}{Gives the grantee READ, READ_ACP, and WRITE_ACP permissions on the
object.

This action is not supported by Amazon S3 on Outposts.}

\item{GrantRead}{Allows grantee to read the object data and its metadata.

This action is not supported by Amazon S3 on Outposts.}

\item{GrantReadACP}{Allows grantee to read the object ACL.

This action is not supported by Amazon S3 on Outposts.}

\item{GrantWriteACP}{Allows grantee to write the ACL for the applicable object.

This action is not supported by Amazon S3 on Outposts.}

\item{Key}{[required] Object key for which the multipart upload is to be initiated.}

\item{Metadata}{A map of metadata to store with the object in S3.}

\item{ServerSideEncryption}{The server-side encryption algorithm used when storing this object in
Amazon S3 (for example, AES256, aws:kms).}

\item{StorageClass}{By default, Amazon S3 uses the STANDARD Storage Class to store newly
created objects. The STANDARD storage class provides high durability and
high availability. Depending on performance needs, you can specify a
different Storage Class. Amazon S3 on Outposts only uses the OUTPOSTS
Storage Class. For more information, see \href{https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage-class-intro.html}{Storage Classes}
in the \emph{Amazon S3 User Guide}.}

\item{WebsiteRedirectLocation}{If the bucket is configured as a website, redirects requests for this
object to another object in the same bucket or to an external URL.
Amazon S3 stores the value of this header in the object metadata.}

\item{SSECustomerAlgorithm}{Specifies the algorithm to use to when encrypting the object (for
example, AES256).}

\item{SSECustomerKey}{Specifies the customer-provided encryption key for Amazon S3 to use in
encrypting data. This value is used to store the object and then it is
discarded; Amazon S3 does not store the encryption key. The key must be
appropriate for use with the algorithm specified in the
\code{x-amz-server-side-encryption-customer-algorithm} header.}

\item{SSECustomerKeyMD5}{Specifies the 128-bit MD5 digest of the encryption key according to RFC
1321. Amazon S3 uses this header for a message integrity check to ensure
that the encryption key was transmitted without error.}

\item{SSEKMSKeyId}{Specifies the ID of the symmetric customer managed key to use for object
encryption. All GET and PUT requests for an object protected by Amazon
Web Services KMS will fail if not made via SSL or using SigV4. For
information about configuring using any of the officially supported
Amazon Web Services SDKs and Amazon Web Services CLI, see \href{https://docs.aws.amazon.com/AmazonS3/latest/userguide/UsingAWSSDK.html#specify-signature-version}{Specifying the Signature Version in Request Authentication}
in the \emph{Amazon S3 User Guide}.}

\item{SSEKMSEncryptionContext}{Specifies the Amazon Web Services KMS Encryption Context to use for
object encryption. The value of this header is a base64-encoded UTF-8
string holding JSON with the encryption context key-value pairs.}

\item{BucketKeyEnabled}{Specifies whether Amazon S3 should use an S3 Bucket Key for object
encryption with server-side encryption using AWS KMS (SSE-KMS). Setting
this header to \code{true} causes Amazon S3 to use an S3 Bucket Key for
object encryption with SSE-KMS.

Specifying this header with an object action doesn’t affect bucket-level
settings for S3 Bucket Key.}

\item{RequestPayer}{}

\item{Tagging}{The tag-set for the object. The tag-set must be encoded as URL Query
parameters.}

\item{ObjectLockMode}{Specifies the Object Lock mode that you want to apply to the uploaded
object.}

\item{ObjectLockRetainUntilDate}{Specifies the date and time when you want the Object Lock to expire.}

\item{ObjectLockLegalHoldStatus}{Specifies whether you want to apply a legal hold to the uploaded object.}

\item{ExpectedBucketOwner}{The account ID of the expected bucket owner. If the bucket is owned by a
different account, the request fails with the HTTP status code
\verb{403 Forbidden} (access denied).}

\item{ChecksumAlgorithm}{Indicates the algorithm you want Amazon S3 to use to create the checksum
for the object. For more information, see \href{https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html}{Checking object integrity}
in the \emph{Amazon S3 User Guide}.}
}
\description{
This action initiates a multipart upload and returns an upload ID. This upload ID is used to associate all of the parts in the specific multipart upload. You specify this upload ID in each of your subsequent upload part requests (see \code{\link[=s3_upload_part]{upload_part}}). You also include this upload ID in the final request to either complete or abort the multipart upload request.

See \url{https://paws-r.github.io/docs/s3/create_multipart_upload.html} for full documentation.
}
\keyword{internal}
