% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recyclebin_operations.R
\name{recyclebin_list_rules}
\alias{recyclebin_list_rules}
\title{Lists the Recycle Bin retention rules in the Region}
\usage{
recyclebin_list_rules(
  MaxResults = NULL,
  NextToken = NULL,
  ResourceType,
  ResourceTags = NULL
)
}
\arguments{
\item{MaxResults}{The maximum number of results to return with a single call. To retrieve
the remaining results, make another call with the returned \code{NextToken}
value.}

\item{NextToken}{The token for the next page of results.}

\item{ResourceType}{[required] The resource type retained by the retention rule. Only retention rules
that retain the specified resource type are listed. Currently, only
Amazon EBS snapshots and EBS-backed AMIs are supported. To list
retention rules that retain snapshots, specify \code{EBS_SNAPSHOT}. To list
retention rules that retain EBS-backed AMIs, specify \code{EC2_IMAGE}.}

\item{ResourceTags}{Information about the resource tags used to identify resources that are
retained by the retention rule.}
}
\description{
Lists the Recycle Bin retention rules in the Region.

See \url{https://paws-r.github.io/docs/recyclebin/list_rules.html} for full documentation.
}
\keyword{internal}
