% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glacier_operations.R
\name{glacier_initiate_job}
\alias{glacier_initiate_job}
\title{This operation initiates a job of the specified type, which can be a
select, an archival retrieval, or a vault retrieval}
\usage{
glacier_initiate_job(accountId, vaultName, jobParameters = NULL)
}
\arguments{
\item{accountId}{[required] The \code{AccountId} value is the AWS account ID of the account that owns the
vault. You can either specify an AWS account ID or optionally a single
'\code{-}' (hyphen), in which case Amazon S3 Glacier uses the AWS account ID
associated with the credentials used to sign the request. If you use an
account ID, do not include any hyphens ('-') in the ID.}

\item{vaultName}{[required] The name of the vault.}

\item{jobParameters}{Provides options for specifying job information.}
}
\description{
This operation initiates a job of the specified type, which can be a select, an archival retrieval, or a vault retrieval. For more information about using this operation, see the documentation for the underlying REST API \href{https://docs.aws.amazon.com/amazonglacier/latest/dev/api-initiate-job-post.html}{Initiate a Job}.

See \url{https://paws-r.github.io/docs/glacier/initiate_job.html} for full documentation.
}
\keyword{internal}
