% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backup_operations.R
\name{backup_put_backup_vault_lock_configuration}
\alias{backup_put_backup_vault_lock_configuration}
\title{Applies Backup Vault Lock to a backup vault, preventing attempts to
delete any recovery point stored in or created in a backup vault}
\usage{
backup_put_backup_vault_lock_configuration(
  BackupVaultName,
  MinRetentionDays = NULL,
  MaxRetentionDays = NULL,
  ChangeableForDays = NULL
)
}
\arguments{
\item{BackupVaultName}{[required] The Backup Vault Lock configuration that specifies the name of the
backup vault it protects.}

\item{MinRetentionDays}{The Backup Vault Lock configuration that specifies the minimum retention
period that the vault retains its recovery points. This setting can be
useful if, for example, your organization's policies require you to
retain certain data for at least seven years (2555 days).

If this parameter is not specified, Vault Lock will not enforce a
minimum retention period.

If this parameter is specified, any backup or copy job to the vault must
have a lifecycle policy with a retention period equal to or longer than
the minimum retention period. If the job's retention period is shorter
than that minimum retention period, then the vault fails that backup or
copy job, and you should either modify your lifecycle settings or use a
different vault. The shortest minimum retention period you can specify
is 1 day. Recovery points already saved in the vault prior to Vault Lock
are not affected.}

\item{MaxRetentionDays}{The Backup Vault Lock configuration that specifies the maximum retention
period that the vault retains its recovery points. This setting can be
useful if, for example, your organization's policies require you to
destroy certain data after retaining it for four years (1460 days).

If this parameter is not included, Vault Lock does not enforce a maximum
retention period on the recovery points in the vault. If this parameter
is included without a value, Vault Lock will not enforce a maximum
retention period.

If this parameter is specified, any backup or copy job to the vault must
have a lifecycle policy with a retention period equal to or shorter than
the maximum retention period. If the job's retention period is longer
than that maximum retention period, then the vault fails the backup or
copy job, and you should either modify your lifecycle settings or use a
different vault. The longest maximum retention period you can specify is
36500 days (approximately 100 years). Recovery points already saved in
the vault prior to Vault Lock are not affected.}

\item{ChangeableForDays}{The Backup Vault Lock configuration that specifies the number of days
before the lock date. For example, setting \code{ChangeableForDays} to 30 on
Jan. 1, 2022 at 8pm UTC will set the lock date to Jan. 31, 2022 at 8pm
UTC.

Backup enforces a 72-hour cooling-off period before Vault Lock takes
effect and becomes immutable. Therefore, you must set
\code{ChangeableForDays} to 3 or greater.

Before the lock date, you can delete Vault Lock from the vault using
\code{\link[=backup_delete_backup_vault_lock_configuration]{delete_backup_vault_lock_configuration}}
or change the Vault Lock configuration using
\code{\link[=backup_put_backup_vault_lock_configuration]{put_backup_vault_lock_configuration}}.
On and after the lock date, the Vault Lock becomes immutable and cannot
be changed or deleted.

If this parameter is not specified, you can delete Vault Lock from the
vault using
\code{\link[=backup_delete_backup_vault_lock_configuration]{delete_backup_vault_lock_configuration}}
or change the Vault Lock configuration using
\code{\link[=backup_put_backup_vault_lock_configuration]{put_backup_vault_lock_configuration}}
at any time.}
}
\description{
Applies Backup Vault Lock to a backup vault, preventing attempts to delete any recovery point stored in or created in a backup vault. Vault Lock also prevents attempts to update the lifecycle policy that controls the retention period of any recovery point currently stored in a backup vault. If specified, Vault Lock enforces a minimum and maximum retention period for future backup and copy jobs that target a backup vault.

See \url{https://paws-r.github.io/docs/backup/put_backup_vault_lock_configuration.html} for full documentation.
}
\keyword{internal}
