% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_operations.R
\name{s3_delete_bucket_policy}
\alias{s3_delete_bucket_policy}
\title{This implementation of the DELETE operation uses the policy subresource
to delete the policy of a specified bucket}
\usage{
s3_delete_bucket_policy(Bucket)
}
\arguments{
\item{Bucket}{[required] The bucket name.}
}
\description{
This implementation of the DELETE operation uses the policy subresource
to delete the policy of a specified bucket. If you are using an identity
other than the root user of the AWS account that owns the bucket, the
calling identity must have the \code{DeleteBucketPolicy} permissions on the
specified bucket and belong to the bucket owner\'s account to use this
operation.
}
\details{
If you don\'t have \code{DeleteBucketPolicy} permissions, Amazon S3 returns a
\verb{403 Access Denied} error. If you have the correct permissions, but
you\'re not using an identity that belongs to the bucket owner\'s
account, Amazon S3 returns a \verb{405 Method Not Allowed} error.

As a security precaution, the root user of the AWS account that owns a
bucket can always use this operation, even if the policy explicitly
denies the root user the ability to perform this action.

For more information about bucket policies, see Using Bucket Policies
and UserPolicies.

The following operations are related to \code{DeleteBucketPolicy}
\itemize{
\item CreateBucket
\item DeleteObject
}
}
\section{Request syntax}{
\preformatted{svc$delete_bucket_policy(
  Bucket = "string"
)
}
}

\examples{
\dontrun{
# The following example deletes bucket policy on the specified bucket.
svc$delete_bucket_policy(
  Bucket = "examplebucket"
)
}

}
\keyword{internal}
