% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backup_operations.R
\name{backup_list_backup_plan_versions}
\alias{backup_list_backup_plan_versions}
\title{Returns version metadata of your backup plans, including Amazon Resource
Names (ARNs), backup plan IDs, creation and deletion dates, plan names,
and version IDs}
\usage{
backup_list_backup_plan_versions(BackupPlanId, NextToken, MaxResults)
}
\arguments{
\item{BackupPlanId}{[required] Uniquely identifies a backup plan.}

\item{NextToken}{The next item following a partial list of returned items. For example,
if a request is made to return \code{maxResults} number of items, \code{NextToken}
allows you to return more items in your list starting at the location
pointed to by the next token.}

\item{MaxResults}{The maximum number of items to be returned.}
}
\description{
Returns version metadata of your backup plans, including Amazon Resource
Names (ARNs), backup plan IDs, creation and deletion dates, plan names,
and version IDs.
}
\section{Request syntax}{
\preformatted{svc$list_backup_plan_versions(
  BackupPlanId = "string",
  NextToken = "string",
  MaxResults = 123
)
}
}

\keyword{internal}
