% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fsx_operations.R
\name{fsx_delete_backup}
\alias{fsx_delete_backup}
\title{Deletes an Amazon FSx for Windows File Server backup, deleting its
contents}
\usage{
fsx_delete_backup(BackupId, ClientRequestToken)
}
\arguments{
\item{BackupId}{[required] The ID of the backup you want to delete.}

\item{ClientRequestToken}{(Optional) A string of up to 64 ASCII characters that Amazon FSx uses to
ensure idempotent deletion. This is automatically filled on your behalf
when using the AWS CLI or SDK.}
}
\description{
Deletes an Amazon FSx for Windows File Server backup, deleting its
contents. After deletion, the backup no longer exists, and its data is
gone.
}
\details{
The \code{DeleteBackup} call returns instantly. The backup will not show up
in later \code{DescribeBackups} calls.

The data in a deleted backup is also deleted and can\'t be recovered by
any means.
}
\section{Request syntax}{
\preformatted{svc$delete_backup(
  BackupId = "string",
  ClientRequestToken = "string"
)
}
}

\examples{
# This operation deletes an Amazon FSx file system backup.
\dontrun{svc$delete_backup(
  BackupId = "backup-03e3c82e0183b7b6b"
)}

}
\keyword{internal}
