% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glacier_operations.R
\name{glacier_list_vaults}
\alias{glacier_list_vaults}
\title{This operation lists all vaults owned by the calling user's account}
\usage{
glacier_list_vaults(accountId, marker, limit)
}
\arguments{
\item{accountId}{[required] The \code{AccountId} value is the AWS account ID. This value must match the
AWS account ID associated with the credentials used to sign the request.
You can either specify an AWS account ID or optionally a single \'\code{-}\'
(hyphen), in which case Amazon Glacier uses the AWS account ID
associated with the credentials used to sign the request. If you specify
your account ID, do not include any hyphens (\'-\') in the ID.}

\item{marker}{A string used for pagination. The marker specifies the vault ARN after
which the listing of vaults should begin.}

\item{limit}{The maximum number of vaults to be returned. The default limit is 10.
The number of vaults returned might be fewer than the specified limit,
but the number of returned vaults never exceeds the limit.}
}
\description{
This operation lists all vaults owned by the calling user\'s account.
The list returned in the response is ASCII-sorted by vault name.
}
\details{
By default, this operation returns up to 10 items. If there are more
vaults to list, the response \code{marker} field contains the vault Amazon
Resource Name (ARN) at which to continue the list with a new List Vaults
request; otherwise, the \code{marker} field is \code{null}. To return a list of
vaults that begins at a specific vault, set the \code{marker} request
parameter to the vault ARN you obtained from a previous List Vaults
request. You can also limit the number of vaults returned in the
response by specifying the \code{limit} parameter in the request.

An AWS account has full permission to perform all operations (actions).
However, AWS Identity and Access Management (IAM) users don\'t have any
permissions by default. You must grant them explicit permission to
perform specific actions. For more information, see \href{https://docs.aws.amazon.com/amazonglacier/latest/dev/using-iam-with-amazon-glacier.html}{Access Control Using AWS Identity and Access Management (IAM)}.

For conceptual information and underlying REST API, see \href{https://docs.aws.amazon.com/amazonglacier/latest/dev/retrieving-vault-info.html}{Retrieving Vault Metadata in Amazon S3 Glacier}
and \href{https://docs.aws.amazon.com/amazonglacier/latest/dev/api-vaults-get.html}{List Vaults}
in the \emph{Amazon Glacier Developer Guide}.
}
\section{Request syntax}{
\preformatted{svc$list_vaults(
  accountId = "string",
  marker = "string",
  limit = "string"
)
}
}

\examples{
# The example lists all vaults owned by the specified AWS account.
\donttest{svc$list_vaults(
  accountId = "-",
  limit = "",
  marker = ""
)}

}
\keyword{internal}
