% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glacier_operations.R
\name{glacier_delete_vault_notifications}
\alias{glacier_delete_vault_notifications}
\title{This operation deletes the notification configuration set for a vault}
\usage{
glacier_delete_vault_notifications(accountId, vaultName)
}
\arguments{
\item{accountId}{[required] The \code{AccountId} value is the AWS account ID of the account that owns the
vault. You can either specify an AWS account ID or optionally a single
\'\code{-}\' (hyphen), in which case Amazon S3 Glacier uses the AWS account
ID associated with the credentials used to sign the request. If you use
an account ID, do not include any hyphens (\'-\') in the ID.}

\item{vaultName}{[required] The name of the vault.}
}
\description{
This operation deletes the notification configuration set for a vault.
The operation is eventually consistent; that is, it might take some time
for Amazon S3 Glacier to completely disable the notifications and you
might still receive some notifications for a short time after you send
the delete request.
}
\details{
An AWS account has full permission to perform all operations (actions).
However, AWS Identity and Access Management (IAM) users don\'t have any
permissions by default. You must grant them explicit permission to
perform specific actions. For more information, see \href{https://docs.aws.amazon.com/amazonglacier/latest/dev/using-iam-with-amazon-glacier.html}{Access Control Using AWS Identity and Access Management (IAM)}.

For conceptual information and underlying REST API, see \href{https://docs.aws.amazon.com/amazonglacier/latest/dev/configuring-notifications.html}{Configuring Vault Notifications in Amazon S3 Glacier}
and \href{https://docs.aws.amazon.com/amazonglacier/latest/dev/api-vault-notifications-delete.html}{Delete Vault Notification Configuration}
in the Amazon S3 Glacier Developer Guide.
}
\section{Request syntax}{
\preformatted{svc$delete_vault_notifications(
  accountId = "string",
  vaultName = "string"
)
}
}

\examples{
# The example deletes the notification configuration set for the vault
# named examplevault.
\donttest{svc$delete_vault_notifications(
  accountId = "-",
  vaultName = "examplevault"
)}

}
\keyword{internal}
