% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/storagegateway_operations.R
\name{storagegateway_list_volume_recovery_points}
\alias{storagegateway_list_volume_recovery_points}
\title{Lists the recovery points for a specified gateway}
\usage{
storagegateway_list_volume_recovery_points(GatewayARN)
}
\arguments{
\item{GatewayARN}{[required]}
}
\description{
Lists the recovery points for a specified gateway. This operation is
only supported in the cached volume gateway type.
}
\details{
Each cache volume has one recovery point. A volume recovery point is a
point in time at which all data of the volume is consistent and from
which you can create a snapshot or clone a new cached volume from a
source volume. To create a snapshot from a volume recovery point use the
CreateSnapshotFromVolumeRecoveryPoint operation.
}
\section{Request syntax}{
\preformatted{svc$list_volume_recovery_points(
  GatewayARN = "string"
)
}
}

\examples{
# Lists the recovery points for a specified gateway in which all data of
# the volume is consistent and can be used to create a snapshot.
\donttest{svc$list_volume_recovery_points(
  GatewayARN = "arn:aws:storagegateway:us-east-1:111122223333:gateway/sgw-12A3456B"
)}

}
\keyword{internal}
