% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_operations.R
\name{s3_get_object_acl}
\alias{s3_get_object_acl}
\title{Returns the access control list (ACL) of an object}
\usage{
s3_get_object_acl(Bucket, Key, VersionId, RequestPayer)
}
\arguments{
\item{Bucket}{[required]}

\item{Key}{[required]}

\item{VersionId}{VersionId used to reference a specific version of the object.}

\item{RequestPayer}{}
}
\description{
Returns the access control list (ACL) of an object.
}
\section{Request syntax}{
\preformatted{svc$get_object_acl(
  Bucket = "string",
  Key = "string",
  VersionId = "string",
  RequestPayer = "requester"
)
}
}

\examples{
# The following example retrieves access control list (ACL) of an object.
\donttest{svc$get_object_acl(
  Bucket = "examplebucket",
  Key = "HappyFace.jpg"
)}

}
\keyword{internal}
