% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_operations.R
\name{s3_list_objects_v2}
\alias{s3_list_objects_v2}
\title{Returns some or all (up to 1000) of the objects in a bucket}
\usage{
s3_list_objects_v2(Bucket, Delimiter, EncodingType, MaxKeys, Prefix,
  ContinuationToken, FetchOwner, StartAfter, RequestPayer)
}
\arguments{
\item{Bucket}{[required] Name of the bucket to list.}

\item{Delimiter}{A delimiter is a character you use to group keys.}

\item{EncodingType}{Encoding type used by Amazon S3 to encode object keys in the response.}

\item{MaxKeys}{Sets the maximum number of keys returned in the response. The response
might contain fewer keys but will never contain more.}

\item{Prefix}{Limits the response to keys that begin with the specified prefix.}

\item{ContinuationToken}{ContinuationToken indicates Amazon S3 that the list is being continued
on this bucket with a token. ContinuationToken is obfuscated and is not
a real key}

\item{FetchOwner}{The owner field is not present in listV2 by default, if you want to
return owner field with each key in the result then set the fetch owner
field to true}

\item{StartAfter}{StartAfter is where you want Amazon S3 to start listing from. Amazon S3
starts listing after this specified key. StartAfter can be any key in
the bucket}

\item{RequestPayer}{Confirms that the requester knows that she or he will be charged for the
list objects request in V2 style. Bucket owners need not specify this
parameter in their requests.}
}
\description{
Returns some or all (up to 1000) of the objects in a bucket. You can use
the request parameters as selection criteria to return a subset of the
objects in a bucket. Note: ListObjectsV2 is the revised List Objects API
and we recommend you use this revised API for new application
development.
}
\section{Request syntax}{
\preformatted{svc$list_objects_v2(
  Bucket = "string",
  Delimiter = "string",
  EncodingType = "url",
  MaxKeys = 123,
  Prefix = "string",
  ContinuationToken = "string",
  FetchOwner = TRUE|FALSE,
  StartAfter = "string",
  RequestPayer = "requester"
)
}
}

\examples{
# The following example retrieves object list. The request specifies max
# keys to limit response to include only 2 object keys.
\donttest{svc$list_objects_v2(
  Bucket = "examplebucket",
  MaxKeys = "2"
)}

}
\keyword{internal}
