% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backup_operations.R
\name{backup_list_recovery_points_by_backup_vault}
\alias{backup_list_recovery_points_by_backup_vault}
\title{Returns detailed information about the recovery points stored in a
backup vault}
\usage{
backup_list_recovery_points_by_backup_vault(BackupVaultName, NextToken,
  MaxResults, ByResourceArn, ByResourceType, ByBackupPlanId,
  ByCreatedBefore, ByCreatedAfter)
}
\arguments{
\item{BackupVaultName}{[required] The name of a logical container where backups are stored. Backup vaults
are identified by names that are unique to the account used to create
them and the AWS Region where they are created. They consist of
lowercase letters, numbers, and hyphens.}

\item{NextToken}{The next item following a partial list of returned items. For example,
if a request is made to return \code{maxResults} number of items, \code{NextToken}
allows you to return more items in your list starting at the location
pointed to by the next token.}

\item{MaxResults}{The maximum number of items to be returned.}

\item{ByResourceArn}{Returns only recovery points that match the specified resource Amazon
Resource Name (ARN).}

\item{ByResourceType}{Returns only recovery points that match the specified resource type.}

\item{ByBackupPlanId}{Returns only recovery points that match the specified backup plan ID.}

\item{ByCreatedBefore}{Returns only recovery points that were created before the specified
timestamp.}

\item{ByCreatedAfter}{Returns only recovery points that were created after the specified
timestamp.}
}
\value{
A list with the following syntax:\preformatted{list(
  NextToken = "string",
  RecoveryPoints = list(
    list(
      RecoveryPointArn = "string",
      BackupVaultName = "string",
      BackupVaultArn = "string",
      SourceBackupVaultArn = "string",
      ResourceArn = "string",
      ResourceType = "string",
      CreatedBy = list(
        BackupPlanId = "string",
        BackupPlanArn = "string",
        BackupPlanVersion = "string",
        BackupRuleId = "string"
      ),
      IamRoleArn = "string",
      Status = "COMPLETED"|"PARTIAL"|"DELETING"|"EXPIRED",
      CreationDate = as.POSIXct(
        "2015-01-01"
      ),
      CompletionDate = as.POSIXct(
        "2015-01-01"
      ),
      BackupSizeInBytes = 123,
      CalculatedLifecycle = list(
        MoveToColdStorageAt = as.POSIXct(
          "2015-01-01"
        ),
        DeleteAt = as.POSIXct(
          "2015-01-01"
        )
      ),
      Lifecycle = list(
        MoveToColdStorageAfterDays = 123,
        DeleteAfterDays = 123
      ),
      EncryptionKeyArn = "string",
      IsEncrypted = TRUE|FALSE,
      LastRestoreTime = as.POSIXct(
        "2015-01-01"
      )
    )
  )
)
}
}
\description{
Returns detailed information about the recovery points stored in a
backup vault.
}
\section{Request syntax}{
\preformatted{svc$list_recovery_points_by_backup_vault(
  BackupVaultName = "string",
  NextToken = "string",
  MaxResults = 123,
  ByResourceArn = "string",
  ByResourceType = "string",
  ByBackupPlanId = "string",
  ByCreatedBefore = as.POSIXct(
    "2015-01-01"
  ),
  ByCreatedAfter = as.POSIXct(
    "2015-01-01"
  )
)
}
}

\keyword{internal}
