% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backup_operations.R
\name{backup_describe_restore_job}
\alias{backup_describe_restore_job}
\title{Returns metadata associated with a restore job that is specified by a
job ID}
\usage{
backup_describe_restore_job(RestoreJobId)
}
\arguments{
\item{RestoreJobId}{[required] Uniquely identifies the job that restores a recovery point.}
}
\value{
A list with the following syntax:\preformatted{list(
  AccountId = "string",
  RestoreJobId = "string",
  RecoveryPointArn = "string",
  CreationDate = as.POSIXct(
    "2015-01-01"
  ),
  CompletionDate = as.POSIXct(
    "2015-01-01"
  ),
  Status = "PENDING"|"RUNNING"|"COMPLETED"|"ABORTED"|"FAILED",
  StatusMessage = "string",
  PercentDone = "string",
  BackupSizeInBytes = 123,
  IamRoleArn = "string",
  ExpectedCompletionTimeMinutes = 123,
  CreatedResourceArn = "string",
  ResourceType = "string"
)
}
}
\description{
Returns metadata associated with a restore job that is specified by a
job ID.
}
\section{Request syntax}{
\preformatted{svc$describe_restore_job(
  RestoreJobId = "string"
)
}
}

\keyword{internal}
