% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_operations.R
\name{s3_put_object_legal_hold}
\alias{s3_put_object_legal_hold}
\title{Applies a Legal Hold configuration to the specified object}
\usage{
s3_put_object_legal_hold(Bucket, Key, LegalHold, RequestPayer,
  VersionId, ContentMD5)
}
\arguments{
\item{Bucket}{[required] The bucket containing the object that you want to place a Legal Hold on.}

\item{Key}{[required] The key name for the object that you want to place a Legal Hold on.}

\item{LegalHold}{Container element for the Legal Hold configuration you want to apply to
the specified object.}

\item{RequestPayer}{}

\item{VersionId}{The version ID of the object that you want to place a Legal Hold on.}

\item{ContentMD5}{The MD5 hash for the request body.}
}
\description{
Applies a Legal Hold configuration to the specified object.
}
\section{Request syntax}{
\preformatted{svc$put_object_legal_hold(
  Bucket = "string",
  Key = "string",
  LegalHold = list(
    Status = "ON"|"OFF"
  ),
  RequestPayer = "requester",
  VersionId = "string",
  ContentMD5 = "string"
)
}
}

\keyword{internal}
