% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_operations.R
\name{s3_create_multipart_upload}
\alias{s3_create_multipart_upload}
\title{Initiates a multipart upload and returns an upload ID}
\usage{
s3_create_multipart_upload(ACL, Bucket, CacheControl,
  ContentDisposition, ContentEncoding, ContentLanguage, ContentType,
  Expires, GrantFullControl, GrantRead, GrantReadACP, GrantWriteACP, Key,
  Metadata, ServerSideEncryption, StorageClass, WebsiteRedirectLocation,
  SSECustomerAlgorithm, SSECustomerKey, SSECustomerKeyMD5, SSEKMSKeyId,
  RequestPayer, Tagging, ObjectLockMode, ObjectLockRetainUntilDate,
  ObjectLockLegalHoldStatus)
}
\arguments{
\item{ACL}{The canned ACL to apply to the object.}

\item{Bucket}{[required]}

\item{CacheControl}{Specifies caching behavior along the request/reply chain.}

\item{ContentDisposition}{Specifies presentational information for the object.}

\item{ContentEncoding}{Specifies what content encodings have been applied to the object and
thus what decoding mechanisms must be applied to obtain the media-type
referenced by the Content-Type header field.}

\item{ContentLanguage}{The language the content is in.}

\item{ContentType}{A standard MIME type describing the format of the object data.}

\item{Expires}{The date and time at which the object is no longer cacheable.}

\item{GrantFullControl}{Gives the grantee READ, READ\_ACP, and WRITE\_ACP permissions on the
object.}

\item{GrantRead}{Allows grantee to read the object data and its metadata.}

\item{GrantReadACP}{Allows grantee to read the object ACL.}

\item{GrantWriteACP}{Allows grantee to write the ACL for the applicable object.}

\item{Key}{[required]}

\item{Metadata}{A map of metadata to store with the object in S3.}

\item{ServerSideEncryption}{The Server-side encryption algorithm used when storing this object in S3
(e.g., AES256, aws:kms).}

\item{StorageClass}{The type of storage to use for the object. Defaults to 'STANDARD'.}

\item{WebsiteRedirectLocation}{If the bucket is configured as a website, redirects requests for this
object to another object in the same bucket or to an external URL.
Amazon S3 stores the value of this header in the object metadata.}

\item{SSECustomerAlgorithm}{Specifies the algorithm to use to when encrypting the object (e.g.,
AES256).}

\item{SSECustomerKey}{Specifies the customer-provided encryption key for Amazon S3 to use in
encrypting data. This value is used to store the object and then it is
discarded; Amazon does not store the encryption key. The key must be
appropriate for use with the algorithm specified in the
x-amz-server-sideâ€‹-encryptionâ€‹-customer-algorithm header.}

\item{SSECustomerKeyMD5}{Specifies the 128-bit MD5 digest of the encryption key according to RFC
1321. Amazon S3 uses this header for a message integrity check to ensure
the encryption key was transmitted without error.}

\item{SSEKMSKeyId}{Specifies the AWS KMS key ID to use for object encryption. All GET and
PUT requests for an object protected by AWS KMS will fail if not made
via SSL or using SigV4. Documentation on configuring any of the
officially supported AWS SDKs and CLI can be found at
http://docs.aws.amazon.com/AmazonS3/latest/dev/UsingAWSSDK.html\#specify-signature-version}

\item{RequestPayer}{}

\item{Tagging}{The tag-set for the object. The tag-set must be encoded as URL Query
parameters}

\item{ObjectLockMode}{Specifies the Object Lock mode that you want to apply to the uploaded
object.}

\item{ObjectLockRetainUntilDate}{Specifies the date and time when you want the Object Lock to expire.}

\item{ObjectLockLegalHoldStatus}{Specifies whether you want to apply a Legal Hold to the uploaded object.}
}
\description{
Initiates a multipart upload and returns an upload ID.
}
\details{
\strong{Note:} After you initiate multipart upload and upload one or more
parts, you must either complete or abort multipart upload in order to
stop getting charged for storage of the uploaded parts. Only after you
either complete or abort multipart upload, Amazon S3 frees up the parts
storage and stops charging you for the parts storage.
}
\section{Request syntax}{
\preformatted{svc$create_multipart_upload(
  ACL = "private"|"public-read"|"public-read-write"|"authenticated-read"|"aws-exec-read"|"bucket-owner-read"|"bucket-owner-full-control",
  Bucket = "string",
  CacheControl = "string",
  ContentDisposition = "string",
  ContentEncoding = "string",
  ContentLanguage = "string",
  ContentType = "string",
  Expires = as.POSIXct(
    "2015-01-01"
  ),
  GrantFullControl = "string",
  GrantRead = "string",
  GrantReadACP = "string",
  GrantWriteACP = "string",
  Key = "string",
  Metadata = list(
    "string"
  ),
  ServerSideEncryption = "AES256"|"aws:kms",
  StorageClass = "STANDARD"|"REDUCED_REDUNDANCY"|"STANDARD_IA"|"ONEZONE_IA"|"INTELLIGENT_TIERING"|"GLACIER"|"DEEP_ARCHIVE",
  WebsiteRedirectLocation = "string",
  SSECustomerAlgorithm = "string",
  SSECustomerKey = raw,
  SSECustomerKeyMD5 = "string",
  SSEKMSKeyId = "string",
  RequestPayer = "requester",
  Tagging = "string",
  ObjectLockMode = "GOVERNANCE"|"COMPLIANCE",
  ObjectLockRetainUntilDate = as.POSIXct(
    "2015-01-01"
  ),
  ObjectLockLegalHoldStatus = "ON"|"OFF"
)
}
}

\examples{
# The following example initiates a multipart upload.
\donttest{svc$create_multipart_upload(
  Bucket = "examplebucket",
  Key = "largeobject"
)}

}
\keyword{internal}
